#!/bin/bash

# Initial pathway (we simply used a linear pathway)
rm centers.txt
for i in `seq 8`
do
    y=`echo $i | awk '{printf "%f",-3+($1-1)*4/7}'`
    z=`echo $i | awk '{printf "%f",3-($1-1)*3/7}'`
    echo $y $z >> centers.txt
done

# Extracting the updated centers for each iteration
# To get the "drifted" or "smoothed" centers prior to reparametrization, use "drifted" or "smoothed" instead of "reparametrized" in grep command
s=""
for i in `seq 8`
do
    cat mdout.001.1 | grep "reparametrized center of image $i" | awk '{print $11,$12}' > centersR.00$i
    s="$s centersR.00$i"
done

paste $s > centersR.txt
cat $s > centersR.all
rm $s
cat centersR.txt | awk '{
    n++
    for (i=1;i<=NF/2;i++) {
	a[n,i]=$(2*i-1)
	b[n,i]=$(2*i)
    }
}END{
    for(i=1;i<=8;i++){
	printf "%d",i
	for(j=1;j<=n;j++) printf " %s %s",a[j,i],b[j,i]
	printf "\n"
    }
}' > centersR.out

# Calculating the dihedral r.m.s.d of each string with respect to (i) initial pathway and (ii) string at previos interation
cat centersR.txt | awk -v c="`cat centers.txt`" 'BEGIN{
    n=split(c,a0)
    for (i=1;i<=n;i++) a_[i]=a0[i]
}{
    s=0
    s_=0
    for (i=1;i<=NF;i++) {
	a[i]=$i
	ds=atan2(sin(a[i]-a0[i]),cos(a[i]-a0[i]))
	ds_=atan2(sin(a[i]-a_[i]),cos(a[i]-a_[i]))
	s+=ds*ds
	s_+=ds_*ds_
	a_[i]=a[i]
    }
    print NR,sqrt(2*s/NF),sqrt(2*s_/NF)
}' > DS.txt

# Now you can plot the results using fig.sh