#!/bin/bash

gnuplot << EOF

set size 1, 1
set terminal postscript eps solid color enhanced lw 3.0 "Times-Roman" 32
set key left top
set encoding iso_8859_1

set xlabel "d_{end} (\305)"
set ylabel "free energy (kcal/mol)"

set xrange [10:35]

set yrange [0:50]
set output "fig-fe.ps"
plot \
"3-abmd/FE-100.txt" u 1:((1+0.03)*(\$2+82)) w l lt 1 lw 2 t "WT-ABMD", \
"4-abmds/FE-100.txt" u 1:((1+0.03)*(\$2+82)) w l lt 3 lw 2 t "WT-ABMD (selection)", \
"5-dabmd/FE-100.txt" u 1:((1+0.03)*(\$2+54)) w l lt -1 lw 2 t "D-WT-ABMD"

set key center bottom
set xlabel "time (ns)"
set ylabel "F(30)-F(15) (kcal/mol)"
set xrange [0:10]
set yrange [0:40]
set output "fig-df.ps"
plot \
"3-abmd/ANALYZE.txt" u (\$1*0.1):((1+0.03)*(\$2)) w l lt 1 lw 2 t "WT-ABMD", \
"4-abmds/ANALYZE.txt" u (\$1*0.1):((1+0.03)*(\$2)) w l lt 3 lw 2 t "WT-ABMD (selection)", \
"5-dabmd/ANALYZE.txt" u (\$1*0.1):((1+0.03)*(\$2)) w l lt -1 lw 2 t "D-WT-ABMD"

EOF

for f in fe df
do
    ps2epsi fig-$f.ps
    epstopdf fig-$f.epsi
done
rm *.ps *.epsi
