#!/bin/bash

echo 0 > df.in
echo 0 > df.out

for f in `ls 5-abmd-1A-8w/*/FE.txt`
do
cat $f | awk -v d=0.05 '{if(int($1/d)==5/d)w5=$2; if(int($1/d)==15/d)w15=$2}END{print w15-w5}' >> df.out
done

for f in `ls 6-abmd-1A-8w-S/*/FE.txt`
do
cat $f | awk -v d=0.05 '{if(int($1/d)==5/d)w5=$2; if(int($1/d)==15/d)w15=$2}END{print w15-w5}' >> df.in
done

gnuplot << EOF

set size 1, 1
set terminal postscript eps solid color enhanced lw 3.0 "Times-Roman" 32
set key center top
set encoding iso_8859_1

set xlabel "d_{end} (\305)"
set ylabel "{/Times-Roman=40 free energy (kcal/mol)}"

set xrange [0:40]

set yrange [-90:-40]
set output "fig5A.ps"
plot \
"3-abmd-5A-4w/FE.txt" w l lt 1 lw 2 t "without selection", \
"4-abmd-5A-4w-S/FE.txt" w l lt 3 lw 2 t "with selection"

set yrange [-50:-20]
set output "fig1A.ps"
plot \
"5-abmd-1A-8w/06/FE.txt" u 1:2 w l lt 1 lw 2 t "without selection", \
"6-abmd-1A-8w-S/06/FE.txt" u 1:2 w l lt 3 lw 2 t "with selection"

set yrange [-25:0]
set output "figS.ps"
plot \
"4-abmd-5A-4w-S/FE.txt" u 1:(\$2+57) w l lt 9 lw 2 t "resolution = 5 \305", \
"6-abmd-1A-8w-S/06/FE.txt" u 1:(\$2+25) w l lt 7 lw 2 t "resolution = 1 \305"

set xlabel "iteration"
set ylabel "E_w/log(N)"
set xrange [0:140]
set yrange [0:1]
set output "figW.ps"
plot \
"4-abmd-5A-4w-S/W.txt" u 1:6 w l lt 9 lw 2 t "resolution = 5 \305", \
"< cat `ls 6-abmd-1A-8w-S/*/W.txt | awk '{printf "%s ",$1}'`" u 0:10 w l lt 7 lw 2 t "resolution = 1 \305"

set nokey
set ylabel "w_i"
set yrange [0:1]

set xrange [0:140]
set output "figW1A.ps"
plot \
"< cat `ls 6-abmd-1A-8w-S/*/W.txt | awk '{printf "%s ",$1}'`" u 2 w l, \
"< cat `ls 6-abmd-1A-8w-S/*/W.txt | awk '{printf "%s ",$1}'`" u 3 w l, \
"< cat `ls 6-abmd-1A-8w-S/*/W.txt | awk '{printf "%s ",$1}'`" u 4 w l, \
"< cat `ls 6-abmd-1A-8w-S/*/W.txt | awk '{printf "%s ",$1}'`" u 5 w l, \
"< cat `ls 6-abmd-1A-8w-S/*/W.txt | awk '{printf "%s ",$1}'`" u 6 w l, \
"< cat `ls 6-abmd-1A-8w-S/*/W.txt | awk '{printf "%s ",$1}'`" u 7 w l, \
"< cat `ls 6-abmd-1A-8w-S/*/W.txt | awk '{printf "%s ",$1}'`" u 8 w l, \
"< cat `ls 6-abmd-1A-8w-S/*/W.txt | awk '{printf "%s ",$1}'`" u 9 w l, \
0.125 lt 0

set output "figX1A.ps"
set xlabel "time (ns)"
set ylabel "d_{end} (\305)"
set xrange [0:1.4]
set yrange [0:50]

set multiplot

set origin 0,0
plot \
"< cat `ls 5-abmd-1A-8w/*/ncsu-abmd-monitor-001 | awk '{printf "%s ",$1}'`" u (\$0/1000):2 w l, \
"< cat `ls 5-abmd-1A-8w/*/ncsu-abmd-monitor-002 | awk '{printf "%s ",$1}'`" u (\$0/1000):2 w l, \
"< cat `ls 5-abmd-1A-8w/*/ncsu-abmd-monitor-003 | awk '{printf "%s ",$1}'`" u (\$0/1000):2 w l, \
"< cat `ls 5-abmd-1A-8w/*/ncsu-abmd-monitor-004 | awk '{printf "%s ",$1}'`" u (\$0/1000):2 w l, \
"< cat `ls 5-abmd-1A-8w/*/ncsu-abmd-monitor-005 | awk '{printf "%s ",$1}'`" u (\$0/1000):2 w l, \
"< cat `ls 5-abmd-1A-8w/*/ncsu-abmd-monitor-006 | awk '{printf "%s ",$1}'`" u (\$0/1000):2 w l, \
"< cat `ls 5-abmd-1A-8w/*/ncsu-abmd-monitor-007 | awk '{printf "%s ",$1}'`" u (\$0/1000):2 w l, \
"< cat `ls 5-abmd-1A-8w/*/ncsu-abmd-monitor-008 | awk '{printf "%s ",$1}'`" u (\$0/1000):2 w l

set origin 1,0
plot \
"< cat `ls 6-abmd-1A-8w-S/*/ncsu-abmd-monitor-001 | awk '{printf "%s ",$1}'`" u (\$0/1000):2 w l, \
"< cat `ls 6-abmd-1A-8w-S/*/ncsu-abmd-monitor-002 | awk '{printf "%s ",$1}'`" u (\$0/1000):2 w l, \
"< cat `ls 6-abmd-1A-8w-S/*/ncsu-abmd-monitor-003 | awk '{printf "%s ",$1}'`" u (\$0/1000):2 w l, \
"< cat `ls 6-abmd-1A-8w-S/*/ncsu-abmd-monitor-004 | awk '{printf "%s ",$1}'`" u (\$0/1000):2 w l, \
"< cat `ls 6-abmd-1A-8w-S/*/ncsu-abmd-monitor-005 | awk '{printf "%s ",$1}'`" u (\$0/1000):2 w l, \
"< cat `ls 6-abmd-1A-8w-S/*/ncsu-abmd-monitor-006 | awk '{printf "%s ",$1}'`" u (\$0/1000):2 w l, \
"< cat `ls 6-abmd-1A-8w-S/*/ncsu-abmd-monitor-007 | awk '{printf "%s ",$1}'`" u (\$0/1000):2 w l, \
"< cat `ls 6-abmd-1A-8w-S/*/ncsu-abmd-monitor-008 | awk '{printf "%s ",$1}'`" u (\$0/1000):2 w l

set nomultiplot

set output "fig8w.ps"
set key center top

set multiplot

set xlabel "time (ns)"
set ylabel "{/Times-Roman=40 F(15)-F(5) (kcal/mol)}"

set xrange [0:2]
set yrange [-10:0]
set origin 0.5,0
plot \
"df.in" u (\$0/5):1 w lp lt 3 lw 2 t "with selection", \
"df.out" u (\$0/5):1 w lp lt 1 lw 2 t "without selection"

set nokey
set xlabel "d_{end} (\305)"
set ylabel "{/Times-Roman=40 free energy (kcal/mol)}"

set xrange [0:40]
set yrange [-50:0]

set origin 0,1
plot \
"5-abmd-1A-8w/00/FE.txt" w l lt 1 lw 2, \
"5-abmd-1A-8w/01/FE.txt" w l lt 1 lw 2, \
"5-abmd-1A-8w/02/FE.txt" w l lt 1 lw 2, \
"5-abmd-1A-8w/03/FE.txt" w l lt 1 lw 2, \
"5-abmd-1A-8w/04/FE.txt" w l lt 1 lw 2, \
"5-abmd-1A-8w/05/FE.txt" w l lt 1 lw 2, \
"5-abmd-1A-8w/06/FE.txt" w l lt 1 lw 2

set origin 1,1
plot \
"6-abmd-1A-8w-S/00/FE.txt" w l lt 3 lw 2, \
"6-abmd-1A-8w-S/01/FE.txt" w l lt 3 lw 2, \
"6-abmd-1A-8w-S/02/FE.txt" w l lt 3 lw 2, \
"6-abmd-1A-8w-S/03/FE.txt" w l lt 3 lw 2, \
"6-abmd-1A-8w-S/04/FE.txt" w l lt 3 lw 2, \
"6-abmd-1A-8w-S/05/FE.txt" w l lt 3 lw 2, \
"6-abmd-1A-8w-S/06/FE.txt" w l lt 3 lw 2

set nomultiplot

EOF

for f in 5A 1A S W W1A X1A 8w
do
    ps2epsi fig$f.ps
    epstopdf fig$f.epsi
done
rm *.ps *.epsi