/* COPYRIGHT_BEGIN
 *    Copyright (c) 1991 SGI   All Rights Reserved
 *    THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF SGI
 *    The copyright notice above does not evidence any
 *    actual or intended publication of such source code,
 *    and is an unpublished work by Silicon Graphics, Inc.
 *    This material contains CONFIDENTIAL INFORMATION that
 *    is the property of Silicon Graphics, Inc. Any use,
 *    duplication or disclosure not specifically authorized
 *    by Silicon Graphics is strictly prohibited.
 *    
 *    RESTRICTED RIGHTS LEGEND:
 *    
 *    Use, duplication or disclosure by the Government is
 *    subject to restrictions as set forth in subdivision
 *    (c)(1)(ii) of the Rights in Technical Data and Computer
 *    Software clause at DFARS 52.227-7013, and/or in similar
 *    or successor clauses in the FAR, DOD or NASA FAR
 *    Supplement.  Unpublished- rights reserved under the
 *    Copyright Laws of the United States.  Contractor is
 *    SILICON GRAPHICS, INC., 2011 N. Shoreline Blvd.,
 *    Mountain View, CA 94039-7311
 * COPYRIGHT_END */

/* 
 * Module generic routines subprogram for module SimpleSphere.
 * Automatically created by module builder at Wed Jan 13 11:59:22 1993.
 * 
 */


/* System include files. */
#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#ifdef _CRAY
#include <fortran.h>
#endif

/* include files from $EXPLORERHOME/include  */
#include <cx/Typedefs.h>
#include <cx/ModuleCommand.h>
#include <cx/DataOps.h>
#include <cx/PortAccess.h>
#include <cx/Coerce.h>
#include <cx/cxMetaType.h>
#include <cx/TypeMismatchMsg.h>
#include <cx/UserFuncs.h>

#include <cx/UDT.h>

#include <cx/Info.h>

#include <cx/DataAccess.h>
#include <cx/cxParameter.api.h>
#include <cx/cxGeometry.api.h>

/* No user specified include files. */


#ifdef __cplusplus
	extern "C" {
#endif
/*****************************************************/

/* Entry points for MCW calling. */
extern long cxMDWsphere(void);

cxFuncTable cx_FuncTable[] = {
		 (cxFuncTable)cxMDWsphere,
		 NULL
};


extern cxMetaType cx_cxMetaTypeMetaType;
extern cxMetaType cx_cxParameterMetaType;
extern cxMetaType cx_cxGeometryMetaType;

void cxModuleMetaTypeInit(void) 
{
    cxMetaTypeAdd(&cx_cxMetaTypeMetaType);
    cxMetaTypeAdd(&cx_cxParameterMetaType);
    cxMetaTypeAdd(&cx_cxGeometryMetaType);

}

/*****************************************************/

/* Entry points for Hook Function calling. */

cxHookTable cx_HookTable[] = {
    { cx_func_last}
};
/*****************************************************/
/* Check Input ports against constraints in module resources. */
cxErrorCode cxPortCheckIn ( int portC, void *ports[], long *cxMDWPortID ) 
{
  cxErrorCode   ec;
  int           portOK;
  void         *cxChkDat;
  char          buf[128], *portData, *msg;


  /* Can't do port checking on alternate executables. */

  if (strcmp( "SimpleSphere", cxModuleNameGet()) != NULL)
    return cx_err_none;
  /* Can't do port checking on variable # ports. */

  if (portC != 3)
    return cx_err_none;
  /* Checking contents of Input datasets. */

  /* No typing information for port 0. */

  /* No typing information for port 1. */

  /* No typing information for port 2. */

  return cx_err_none;
}
/*****************************************************/
/* Check Output ports against constraints in module resources. */
cxErrorCode cxPortCheckOut ( int portC, void *ports[], long *cxMDWPortID ) 
{
  cxErrorCode   ec;
  int           portOK;
  void         *cxChkDat;
  char          buf[128], *portData, *msg;


  /* Can't do port checking on alternate executables. */

  if (strcmp( "SimpleSphere", cxModuleNameGet()) != NULL)
    return cx_err_none;
  /* Can't do port checking on variable # ports. */

  if (portC != 1)
    return cx_err_none;
  /* Checking contents of Output datasets. */
  cxChkDat  = ports[0];
  if (cxChkDat) {
    /* Only check optional port when it has data */
  }

  return cx_err_none;
}

#ifdef __cplusplus
}
#endif

