/* COPYRIGHT_BEGIN
 *    Copyright (c) 1991 SGI   All Rights Reserved
 *    THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF SGI
 *    The copyright notice above does not evidence any
 *    actual or intended publication of such source code,
 *    and is an unpublished work by Silicon Graphics, Inc.
 *    This material contains CONFIDENTIAL INFORMATION that
 *    is the property of Silicon Graphics, Inc. Any use,
 *    duplication or disclosure not specifically authorized
 *    by Silicon Graphics is strictly prohibited.
 *    
 *    RESTRICTED RIGHTS LEGEND:
 *    
 *    Use, duplication or disclosure by the Government is
 *    subject to restrictions as set forth in subdivision
 *    (c)(1)(ii) of the Rights in Technical Data and Computer
 *    Software clause at DFARS 52.227-7013, and/or in similar
 *    or successor clauses in the FAR, DOD or NASA FAR
 *    Supplement.  Unpublished- rights reserved under the
 *    Copyright Laws of the United States.  Contractor is
 *    SILICON GRAPHICS, INC., 2011 N. Shoreline Blvd.,
 *    Mountain View, CA 94039-7311
 * COPYRIGHT_END */

/* 
 * Module data wrapper subprogram for module Projector.
 * Automatically created by module builder at Fri Jan 15 07:28:23 1993.
 * 
 */


/* System include files. */
#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#ifdef _CRAY
#include <fortran.h>
#endif

/* include files from $EXPLORERHOME/include  */
#include <cx/Typedefs.h>
#include <cx/ModuleCommand.h>
#include <cx/DataOps.h>
#include <cx/PortAccess.h>
#include <cx/Coerce.h>
#include <cx/cxMetaType.h>
#include <cx/TypeMismatchMsg.h>
#include <cx/UserFuncs.h>

#include <cx/UDT.h>

#include <cx/Info.h>

#include <cx/DataAccess.h>
#include <cx/cxPyramid.api.h>
#include <cx/cxLattice.api.h>
#include <cx/cxParameter.api.h>

/* No user specified include files. */



  /* --- User Fcn call prototype. --- */
#include <cx/cxPyramid.api.h>
#include <cx/cxLattice.api.h>
#include <cx/cxParameter.api.h>

#ifdef __cplusplus
	extern "C" {
#endif

  void 	projector  (
	 long   	  projType, 
	 double 	  globeRadius, 
	 double 	  mapz, 
	 double 	  paramOne, 
	 double 	  paramTwo, 
	 double 	  paramThree, 
	 double 	  paramFour, 
	 cxPyramid *	  mapIn, 
	 cxPyramid *	* mapOut, 
	 cxPyramid *	  pyr1In, 
	 cxPyramid *	* pyr1Out, 
	 cxPyramid *	  pyr2In, 
	 cxPyramid *	* pyr2Out, 
	 cxPyramid *	  pyr3In, 
	 cxPyramid *	* pyr3Out, 
	 cxLattice *	  lat1In, 
	 cxLattice *	* lat1Out, 
	 cxLattice *	  lat2In, 
	 cxLattice *	* lat2Out );

#ifdef __cplusplus
}
#endif


/* Number of user function arguments. */
#define cxMDWNARGprojector 19

long cxMDWprojector( )
{

/* ----- Beginning of port declarations ----- */

/* Port dataset variable declarations */

  cxPyramid *cxP_In_Map;
  cxPyramid *cxP_In_Pyramid_1;
  cxPyramid *cxP_In_Pyramid_2;
  cxPyramid *cxP_In_Pyramid_3;
  cxLattice *cxP_In_Lattice_1;
  cxLattice *cxP_In_Lattice_2;
  cxParameter *cxP_In_Projection;
  cxParameter *cxP_In_Globe_Radius;
  cxParameter *cxP_In_Map_z;
  cxParameter *cxP_In_Base_Long_;
  cxParameter *cxP_In_Base_Lat_;
  cxParameter *cxP_In_1st__St__Par_;
  cxParameter *cxP_In_2nd__St__Par_;
  cxPyramid *cxP_Out_Map;
  cxPyramid *cxP_Out_Pyramid_1;
  cxPyramid *cxP_Out_Pyramid_2;
  cxPyramid *cxP_Out_Pyramid_3;
  cxLattice *cxP_Out_Lattice_1;
  cxLattice *cxP_Out_Lattice_2;

/* --- End of port and dataset declarations ---- */


/* -- Beginning of User Fcn variable declarations -- */

  long    projType; 
  double  globeRadius; 
  double  mapz; 
  double  paramOne; 
  double  paramTwo; 
  double  paramThree; 
  double  paramFour; 
  cxPyramid * mapIn; 
  cxPyramid * mapOut; 
  cxPyramid * pyr1In; 
  cxPyramid * pyr1Out; 
  cxPyramid * pyr2In; 
  cxPyramid * pyr2Out; 
  cxPyramid * pyr3In; 
  cxPyramid * pyr3Out; 
  cxLattice * lat1In; 
  cxLattice * lat1Out; 
  cxLattice * lat2In; 
  cxLattice * lat2Out; 

/* ------ End of User Fcn declarations ------ */

  long   cxMDWi, cxMDWIrc;
  long   cxMDWIfCoerce[ cxMDWNARGprojector ];
  char *cxMDWStr;
  long  cxMDWFuncRetCode;
  char  cxMDWFuncBuf[256];
  long  cxMDWLen;
  long  cxMDWPortIDIn[13];
  long  cxMDWPortIDOut[6];
  void *tmp;
  int  *cxMDWTypeTab;
  cxDataCheckErrorInfo  *cxMDWCheckErr;
  cxErrorCode   ec;
/* ------------------------------------------ */
/* ----- Beginning of Port Associations ----- */

/* -------- First executable statment ------- */


  /* Get input port handles. */ 
  cxMDWPortIDIn[0] = cxInputPortOpen( "Map" );
  cxMDWPortIDIn[1] = cxInputPortOpen( "Pyramid 1" );
  cxMDWPortIDIn[2] = cxInputPortOpen( "Pyramid 2" );
  cxMDWPortIDIn[3] = cxInputPortOpen( "Pyramid 3" );
  cxMDWPortIDIn[4] = cxInputPortOpen( "Lattice 1" );
  cxMDWPortIDIn[5] = cxInputPortOpen( "Lattice 2" );
  cxMDWPortIDIn[6] = cxInputPortOpen( "Projection" );
  cxMDWPortIDIn[7] = cxInputPortOpen( "Globe Radius" );
  cxMDWPortIDIn[8] = cxInputPortOpen( "Map z" );
  cxMDWPortIDIn[9] = cxInputPortOpen( "Base Long." );
  cxMDWPortIDIn[10] = cxInputPortOpen( "Base Lat." );
  cxMDWPortIDIn[11] = cxInputPortOpen( "1st. St. Par." );
  cxMDWPortIDIn[12] = cxInputPortOpen( "2nd. St. Par." );

  /* Get output port handles. */ 
  cxMDWPortIDOut[0] = cxOutputPortOpen( "Map" );
  cxMDWPortIDOut[1] = cxOutputPortOpen( "Pyramid 1" );
  cxMDWPortIDOut[2] = cxOutputPortOpen( "Pyramid 2" );
  cxMDWPortIDOut[3] = cxOutputPortOpen( "Pyramid 3" );
  cxMDWPortIDOut[4] = cxOutputPortOpen( "Lattice 1" );
  cxMDWPortIDOut[5] = cxOutputPortOpen( "Lattice 2" );

  /* Get dataset pointers. */ 
  cxP_In_Map = ( cxPyramid *) cxInputDataGet( cxMDWPortIDIn[0] );
  cxP_In_Pyramid_1 = ( cxPyramid *) cxInputDataGet( cxMDWPortIDIn[1] );
  cxP_In_Pyramid_2 = ( cxPyramid *) cxInputDataGet( cxMDWPortIDIn[2] );
  cxP_In_Pyramid_3 = ( cxPyramid *) cxInputDataGet( cxMDWPortIDIn[3] );
  cxP_In_Lattice_1 = ( cxLattice *) cxInputDataGet( cxMDWPortIDIn[4] );
  cxP_In_Lattice_2 = ( cxLattice *) cxInputDataGet( cxMDWPortIDIn[5] );
  cxP_In_Projection = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[6] );
  cxP_In_Globe_Radius = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[7] );
  cxP_In_Map_z = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[8] );
  cxP_In_Base_Long_ = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[9] );
  cxP_In_Base_Lat_ = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[10] );
  cxP_In_1st__St__Par_ = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[11] );
  cxP_In_2nd__St__Par_ = ( cxParameter *) cxInputDataGet( cxMDWPortIDIn[12] );

  /* Initialize the coercion status flags. */
  for (cxMDWi=0; cxMDWi< cxMDWNARGprojector; cxMDWi++) 
    cxMDWIfCoerce[cxMDWi] = TRUE;


  /* Assign user function values. */
  /* Extracting User Function variables from ports. */

  if (0 && !cxP_In_Projection) {
    projType = NULL;
    cxMDWIfCoerce[0] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_long );	/* return of type (long    *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_Projection, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_Projection, &ec ) ), 
	  cx_prim_long, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    projType = *(long    *) tmp;

    cxMDWIfCoerce[0] = FALSE;
    cxVecDel( tmp );
  }

  if (0 && !cxP_In_Globe_Radius) {
    globeRadius = NULL;
    cxMDWIfCoerce[1] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_double );	/* return of type (double  *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_Globe_Radius, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_Globe_Radius, &ec ) ), 
	  cx_prim_double, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    globeRadius = *(double  *) tmp;

    cxMDWIfCoerce[1] = FALSE;
    cxVecDel( tmp );
  }

  if (0 && !cxP_In_Map_z) {
    mapz = NULL;
    cxMDWIfCoerce[2] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_double );	/* return of type (double  *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_Map_z, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_Map_z, &ec ) ), 
	  cx_prim_double, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    mapz = *(double  *) tmp;

    cxMDWIfCoerce[2] = FALSE;
    cxVecDel( tmp );
  }

  if (0 && !cxP_In_Base_Long_) {
    paramOne = NULL;
    cxMDWIfCoerce[3] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_double );	/* return of type (double  *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_Base_Long_, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_Base_Long_, &ec ) ), 
	  cx_prim_double, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    paramOne = *(double  *) tmp;

    cxMDWIfCoerce[3] = FALSE;
    cxVecDel( tmp );
  }

  if (0 && !cxP_In_Base_Lat_) {
    paramTwo = NULL;
    cxMDWIfCoerce[4] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_double );	/* return of type (double  *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_Base_Lat_, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_Base_Lat_, &ec ) ), 
	  cx_prim_double, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    paramTwo = *(double  *) tmp;

    cxMDWIfCoerce[4] = FALSE;
    cxVecDel( tmp );
  }

  if (0 && !cxP_In_1st__St__Par_) {
    paramThree = NULL;
    cxMDWIfCoerce[5] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_double );	/* return of type (double  *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_1st__St__Par_, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_1st__St__Par_, &ec ) ), 
	  cx_prim_double, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    paramThree = *(double  *) tmp;

    cxMDWIfCoerce[5] = FALSE;
    cxVecDel( tmp );
  }

  if (0 && !cxP_In_2nd__St__Par_) {
    paramFour = NULL;
    cxMDWIfCoerce[6] = FALSE;
  }
  else {
    tmp = (void*)cxVecNew( 1, cx_prim_double );	/* return of type (double  *) */
    if (!tmp)
      return((long) cx_err_error);

    cxVecClipSet( 0, 0 );
    cxMDWIrc = cxVecCoerce( 1, 
	  cxParameterValueType( cxP_In_2nd__St__Par_, &ec ), 
	  (void*) ( (double *)  cxParameterValueGet( cxP_In_2nd__St__Par_, &ec ) ), 
	  cx_prim_double, 
	  (void*) tmp );

    if (cxMDWIrc != cx_err_none)
      return((long) cxMDWIrc);

    paramFour = *(double  *) tmp;

    cxMDWIfCoerce[6] = FALSE;
    cxVecDel( tmp );
  }

  if (1 && !cxP_In_Map) {
    mapIn = NULL;
    cxMDWIfCoerce[7] = FALSE;
  }
  else {
  mapIn = (cxPyramid *) cxP_In_Map;
  }

  if (1 && !cxP_In_Pyramid_1) {
    pyr1In = NULL;
    cxMDWIfCoerce[9] = FALSE;
  }
  else {
  pyr1In = (cxPyramid *) cxP_In_Pyramid_1;
  }

  if (1 && !cxP_In_Pyramid_2) {
    pyr2In = NULL;
    cxMDWIfCoerce[11] = FALSE;
  }
  else {
  pyr2In = (cxPyramid *) cxP_In_Pyramid_2;
  }

  if (1 && !cxP_In_Pyramid_3) {
    pyr3In = NULL;
    cxMDWIfCoerce[13] = FALSE;
  }
  else {
  pyr3In = (cxPyramid *) cxP_In_Pyramid_3;
  }

  if (1 && !cxP_In_Lattice_1) {
    lat1In = NULL;
    cxMDWIfCoerce[15] = FALSE;
  }
  else {
  lat1In = (cxLattice *) cxP_In_Lattice_1;
  }

  if (1 && !cxP_In_Lattice_2) {
    lat2In = NULL;
    cxMDWIfCoerce[17] = FALSE;
  }
  else {
  lat2In = (cxLattice *) cxP_In_Lattice_2;
  }
  /* Assigning constant User Function variables. */
  /* Assigning whether data has changed to User Function variables. */
  /* Allocation of User Function variables. */
  mapOut = (cxPyramid *) NULL; 
  pyr1Out = (cxPyramid *) NULL; 
  pyr2Out = (cxPyramid *) NULL; 
  pyr3Out = (cxPyramid *) NULL; 
  lat1Out = (cxLattice *) NULL; 
  lat2Out = (cxLattice *) NULL; 

  projector( projType, 
      globeRadius, mapz, paramOne, paramTwo, 
      paramThree, paramFour, mapIn, &mapOut, 
      pyr1In, &pyr1Out, pyr2In, &pyr2Out, 
      pyr3In, &pyr3Out, lat1In, &lat1Out, 
      lat2In, &lat2Out );

  if (cxDataAllocErrorGet())
    return( cx_err_error );

/* Beginning of output port assembly. */

  /* Output port assembly for port "Map". */

  cxP_Out_Map = (cxPyramid *) mapOut;








  /* Output port assembly for port "Pyramid 1". */

  cxP_Out_Pyramid_1 = (cxPyramid *) pyr1Out;








  /* Output port assembly for port "Pyramid 2". */

  cxP_Out_Pyramid_2 = (cxPyramid *) pyr2Out;








  /* Output port assembly for port "Pyramid 3". */

  cxP_Out_Pyramid_3 = (cxPyramid *) pyr3Out;








  /* Output port assembly for port "Lattice 1". */

  cxP_Out_Lattice_1 = (cxLattice *) lat1Out;



  /* Output port assembly for port "Lattice 2". */

  cxP_Out_Lattice_2 = NULL;

/* End of output port assembly. */


/* Free temporarily assigned user vars. */

  cxOutputDataSet( cxMDWPortIDOut[0], (void *)cxP_Out_Map );
  cxOutputDataSet( cxMDWPortIDOut[1], (void *)cxP_Out_Pyramid_1 );
  cxOutputDataSet( cxMDWPortIDOut[2], (void *)cxP_Out_Pyramid_2 );
  cxOutputDataSet( cxMDWPortIDOut[3], (void *)cxP_Out_Pyramid_3 );
  cxOutputDataSet( cxMDWPortIDOut[4], (void *)cxP_Out_Lattice_1 );
  cxOutputDataSet( cxMDWPortIDOut[5], (void *)cxP_Out_Lattice_2 );
  return( cx_err_none );
}
