#include <math.h>

// reference CPU kernel
void cpu_scalar(int ngrid,int natom,
            float *ax,float *ay,float *az,
            float *gx,float *gy,float *gz,
            float *charge,float *size,
            float xkappa,float pre1,
            float *val){

    int igrid, iatom;

    float dist;
    //#pragma omp parallel for private(igrid,iatom,dist)
    for(igrid=0;igrid<ngrid;igrid++){
        for(iatom=0; iatom<natom; iatom++){
            dist = sqrtf((gx[igrid]-ax[iatom])*(gx[igrid]-ax[iatom]) +
                         (gy[igrid]-ay[iatom])*(gy[igrid]-ay[iatom]) +
                         (gz[igrid]-az[iatom])*(gz[igrid]-az[iatom]));

            val[igrid] += pre1*(charge[iatom]/dist)*expf(-xkappa*(dist-size[iatom]))
            / (1+xkappa*size[iatom]);
        }
    }
}


// optimized reference CPU kernel
void cpu_scalar_opt(int ngrid,int natom,
            float *ax,float *ay,float *az,
            float *gx,float *gy,float *gz,
            float *charge,float *size,
            float xkappa,float pre1,
            float *val){
    int igrid, iatom;
    float dist;

//#pragma omp parallel for private(igrid,iatom,dist)
    for(igrid=0; igrid<ngrid; igrid++){
        float v=0.0f;
        for(iatom=0; iatom<natom; iatom++){
            float dx = gx[igrid] - ax[iatom];
            float dy = gy[igrid] - ay[iatom];
            float dz = gz[igrid] - az[iatom];

            dist = sqrtf(dx*dx + dy*dy + dz*dz);
            v += (charge[iatom]/dist)*expf(-xkappa*(dist-size[iatom]))
                 / (1.0f+xkappa*size[iatom]);
        }
        val[igrid] = pre1 * v;
    }
}


