#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "WKFThreads.h"
#include "CUDAKernels.h"
#include "rworbitals.h"

int main(int argc, char **argv) {
  int rc, i;
  wkf_threadpool_t *devpool = NULL;

#if !defined(CUDA)
  if (getenv("VMDNOOPENCL")) {
    printf("No CUDA support in this build, exiting...\n");
    return -1;
  }
#endif

  if (argc != 2) {
    printf("usage: %s orbitalfilename.txt\n", argv[0]); 
    return -1;
  }

  int device = 0;
  devpool = wkf_threadpool_create(1, &device);

  // warmup runs to wake up the GPU
  printf("*** Running warmup calculations to wake up the GPU/CPU...\n");
  for (i=0; i<3; i++) 
    read_calc_orbitals(devpool, argv[1], 0);
  printf("\n");

  printf("*** Running benchmark calculation...\n");
  rc=read_calc_orbitals(devpool, argv[1], 1);   

  return rc;
}
