# Written by Fangqiang Zhu, 6/3/2002

# Make a m*m nanotube with length n.
# Write to $output.psf and $output.pdb


proc make_arm {m n output} {

  # Bond length
  set a 1.3750
  set PI 3.141592654
  set tt [expr 2*$PI/(3*$m)]
  set r [expr $a/(2*sin($PI/3/$m))]

  set fd_top [open temp_armchair.top w]
  # Version number
  puts $fd_top "0 0"
  puts $fd_top "MASS     1 CA    12.01100 C"
  puts $fd_top "AUTO ANGLES DIHE"
  puts $fd_top "RESI ARM          0.00"
  
  set fd_pgn [open temp_armchair.pgn w]
  puts $fd_pgn "topology temp_armchair.top"
  puts $fd_pgn "segment NT {residue 1 ARM}"
  
  # Define the atom names for each carbon
  set ind 0
  for {set i 0} {$i<$n} {incr i} {
    for {set j 0} {$j<$m} {incr j} {
      for {set k 0} {$k<2} {incr k} {
        if {$ind > 99} {
          set name($i,$j,$k) C$ind
        } elseif {$ind > 9} {
          set name($i,$j,$k) C0$ind
        } else {
          set name($i,$j,$k) C00$ind
        }
        incr ind
      }
    }
  }
  
  for {set i 0} {$i<$n} {incr i} {
    set z [expr ($i-($n-1)/2.0)*sqrt(3)/2*$a]
    set t0 [expr ($i%2==0)?0:1.5*$tt]
    for {set j 0} {$j<$m} {incr j} {
      puts $fd_top "ATOM $name($i,$j,0) CA      0.00"
      set t [expr $t0+(3*$j-0.5)*$tt]
      puts $fd_pgn "coord NT 1 $name($i,$j,0) {[expr $r*cos($t)] [expr $r*sin($t)] $z}"
      puts $fd_top "ATOM $name($i,$j,1) CA      0.00"
      set t [expr $t0+(3*$j+0.5)*$tt]
      puts $fd_pgn "coord NT 1 $name($i,$j,1) {[expr $r*cos($t)] [expr $r*sin($t)] $z}"
      puts $fd_top "BOND $name($i,$j,0) $name($i,$j,1)"
      if {$i%2 == 1} {
        set ii [expr $i-1]
        set jj [expr ($j+1)%$m]
        puts $fd_top "BOND $name($ii,$j,1) $name($i,$j,0)"
        puts $fd_top "BOND $name($ii,$jj,0) $name($i,$j,1)"
      } elseif {$i > 0} {
        set ii [expr $i-1]
        set jj [expr ($j-1)%$m]
        puts $fd_top "BOND $name($ii,$jj,1) $name($i,$j,0)"
        puts $fd_top "BOND $name($ii,$j,0) $name($i,$j,1)"
      }
    }
  }
  
  puts $fd_pgn "writepsf $output.psf"
  puts $fd_pgn "writepdb $output.pdb"
  
  close $fd_top
  close $fd_pgn
  
  exec psfgen temp_armchair.pgn
  exec rm temp_armchair.top
  exec rm temp_armchair.pgn
}
