set name EcBamA

mol new ../../MembBuilding/${name}.psf
mol addfile ../../MembBuilding/${name}.pdb

set all [atomselect top all]

#lipid tail of lipid A
set relax1 [atomselect top "resname ECLIPA and not ((name C11 C12 C13 C31 C32 C33 C51 C52 C53 C61 C71 C72 C73 C81 CA1 CA2 CA3 CA4 CA5 CA6 CB1 CB2 CB3 CB4 CB5 CB6 CC1 CC3 CC5 CC6 CC7) or (mass 1.008 and (not type HAL2 HAL3 or name H12R H12S H32R H32S H52R H52S H72R H72S)) or (mass 14.00) or (mass 30.97) or (mass 15.99))"]

#lipid tail of phospholipid
set relax2 [atomselect top "((resname PMPE or resname PVPE) and not (name C1 C11 C12 C2 C21 C3 C31 HN1 HN2 HN3 H11A H11B H12A H12B HA HB HS HX HY O11 O12 O13 O14 O21 O22 O31 O32 N P)) or ((resname PMPG or resname PVPG) and not (name C1 C11 C12 C13 C2 C21 C3 C31 H11A H11B H12A H13A H13B HA HB HO2 HO3 HS HX HY OC2 OC3 O11 O12 O13 O14 O21 O22 O31 O32 P)) or (resname PVCL2 and not (name C1 C11 C12 C13 C2 C3 C31 C32 C33 CA1 CB1 CC1 CD1 H11J H11K H12J H13J H13K H31J H31K H32J H33J H33K HG11 HG12 HG22 HG31 HG32 HO12 O12 OA1 O13 OB1 O31 OD1 O32 OC1 OP11 OP12 OP13 OP14 OP31 OP32 OP33 OP34 OG12 P1 P3))"]

$all set beta 1
$relax1 set beta 0
$relax2 set beta 0


$all writepdb ${name}_S1.cnst


quit




