#ifndef ALPHABET_H
#define ALPHABET_H

#include "symbol.h"
#include <string.h>

/****************
 * Acts like a singleton
 ****************/
class Alphabet {

 public:
  Alphabet(int l, Symbol** alpha);
  Alphabet(int t, int l, Symbol** alpha);
  ~Alphabet();

  Symbol* getSymbol(char c);
  Symbol* getSymbol(char* chars);
  Symbol* getSymbol(Symbol* symbol);
  char* getBackbone();
  Symbol* getGap();
  Symbol* getUnknown();
  int setBackbone(char* c);
  int setGap(Symbol* symbol);
  int setUnknown(Symbol* symbol);
  int isGap(Symbol* symbol);
  int isUnknown(Symbol* symbol);
  int hasSymbol(Symbol* symbol);
  int hasUniqueOnes();
  int hasUniqueThrees();
  int hasUniqueFulls();
  char* toString();

 private:
  int checkSymbolUniqueness();

 public:
  enum{ DNA, RNA, Protein };

 private:
  Symbol** alphabet;
  Symbol* gap;
  Symbol* unknown;
  char* backbone;
  int type;
  int length;


};

#endif
