
#include "alphabet.h"

#include <stdio.h>

Alphabet::Alphabet(int l, Symbol** alpha)
  : gap(0), unknown(0), type(0), length(l) {

  backbone = 0;

  alphabet = new Symbol* [l];
  for (int i=0; i<length; i++) {
    alphabet[i] = alpha[i]->clone();
  }

  checkSymbolUniqueness();  // make sure alphabet is a set

  return;
}


Alphabet::Alphabet(int t, int l, Symbol** alpha) 
  : type(t), length(l) {

  backbone = 0;

  alphabet = new Symbol* [l];
  for (int i=0; i<length; i++) {
    alphabet[i] = alpha[i]->clone();
  }

  checkSymbolUniqueness();  // make sure alphabet is a set

  return;
}


Alphabet::~Alphabet() {

  for (int i=0; i<length; i++) {
    delete alphabet[i];
  }

  delete alphabet;
  delete backbone;

  return;
}


Symbol* Alphabet::getSymbol(char c) {

  if ( !hasUniqueOnes() ) {
    return 0;
  }

  for (int i=0; i<length; i++) {
    if (c == alphabet[i]->getOne()) {
      return alphabet[i];
    }
  }

  if (getUnknown() != 0) {
    return getUnknown();
  }

  return 0;
}


Symbol* Alphabet::getSymbol(char* chars) {
  
  int len = strlen(chars);

  if (len == 3) {
    for (int i=0; i<length; i++) {
      if ( strncmp(alphabet[i]->getThree(),chars,3) == 0 ) {
	return alphabet[i];
      }
    }
  }
  
  // XXX - NEED CASE FOR LEN !=3
  /*
  for (int i=0; i<length; i++) {
    
  }
  */

  if (getUnknown() != 0) {
    return getUnknown();
  }

  return 0;
}


Symbol* Alphabet::getSymbol(Symbol* symbol) {

  for (int i=0; i<length; i++) {
    if (symbol->equals(alphabet[i])) {
      return alphabet[i];
    }
  }

  if (getUnknown() != 0) {
    return getUnknown();
  }
  
  return 0;
}


char* Alphabet::getBackbone() {

  if (backbone == 0) {
    return 0;
  }

  int len = strlen(backbone);
  char* result = new char[len+1];
  strncpy(result,backbone,len);
  result[len] = '\0';

  return result;
}


// getGap
Symbol* Alphabet::getGap() {

  if (gap == 0) {
    return 0;
  }

  return gap;
}


// getUnknown
Symbol* Alphabet::getUnknown() {

  if (unknown == 0) {
    return 0;
  }

  return unknown;
}


// setBackbone
//   input:
//      str - string that corresponds to the backbone atom
int Alphabet::setBackbone(char* str) {

  if (backbone != 0) {
    delete backbone;
  }

  int len = strlen(str);
  backbone = new char[len+1];
  strncpy(backbone,str,len);
  backbone[len] = '\0';
  
  return 0;
}


// setGap
int Alphabet::setGap(Symbol* symbol) {

  if (hasSymbol(symbol)) {
    gap = symbol;
    return 1;
  }

  return 0;
}


// setUnknown
int Alphabet::setUnknown(Symbol* symbol) {

  if (hasSymbol(symbol)) {
    unknown = symbol;
    return 1;
  }

  return 0;
}


// isGap
int Alphabet::isGap(Symbol* symbol) {

  if ( hasSymbol(symbol) &&
       symbol->equals(getGap()) ) {
    return 1;
  }

  return 0;
}


// isUnknown
int Alphabet::isUnknown(Symbol* symbol) {

  if ( hasSymbol(symbol) &&
       symbol->equals(getUnknown()) ) {
    return 1;
  }

  return 0;
}

// hasSymbol
int Alphabet::hasSymbol(Symbol* symbol) {

  for (int i=0; i<length; i++) {
    if (alphabet[i]->equals(symbol)) {
      return 1;
    }
  }

  return 0;
}


int Alphabet::hasUniqueOnes() {

  return 1;
}


int Alphabet::hasUniqueThrees() {

  return 0;
}


int Alphabet::hasUniqueFulls() {

  return 0;
}



int Alphabet::checkSymbolUniqueness() {
  
  for (int i=0; i<length; i++) {
    for (int j=i+1; j<length; j++) {
      if (alphabet[i]->equals(alphabet[j])) {
	return 0;
      }
    }
  }
  
  return 1;
}


char* Alphabet::toString() {
  
  char* str = new char[length*2];

  int i=0;
  for (; i<length; i++) {
    str[i*2] = alphabet[i]->getOne();
    str[(i*2)+1] = ' ';
  }
  i--;
  str[(i*2)+1] = '\0';

  //printf("i: %d\n",i);

  return str;
}
