#ifndef AATOOLS_H
#define AATOOLS_H

//#include <fstream.h>
//#include <iostream.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "alignment.h"
#include "matrix.h"

// eventually these should be CLAs
#define DB 0 // set to 1 in to debug
#define ADD_GAP_PENALTY 0 // affinity score penalty for gaps
#define DO_NC2 0 // computes affinScore on all pairs columnwise
#define SCALE 2 // bit-units for matrices
#define MSL 2000 // max seq length allowable, used for temporary buffers

// set paths
#define BLOSUM_PATH "/home/mjanuszy/Projects/ssAlign/data/BLOSUM/"
#define PDB_PATH "/home/mjanuszy/Projects/ssAlign/data/RotatedPDB/"
#define DSSP_PATH "/home/mjanuszy/Programs/Dssp/dssp"
#define TMP_PATH "/tmp/"

// set color definitions for linux terminal display
#define BLK printf("\033[22;30m");
#define RED printf("\033[22;31m");
#define GRE printf("\033[22;32m");
#define YEL printf("\033[22;33m");
#define BLU printf("\033[22;34m");
#define VIO printf("\033[22;35m");
#define IND printf("\033[22;36m");
#define GRY printf("\033[22;37m");


//using namespace std;

Alignment aaToSS(Alignment);
void jackKnife(char *msaFileName); // just calc correlation coef for each
void jackKnife(char *msaFileName, char *qFile); // also print pairwise-q's
float corr2(Matrix m1, Matrix m2); // correlation coefficient
float getAvgCaDist(Alignment, int, int); // Msa
void getBlockStatsMsa(Alignment);
void getBlockStatsPwa(Alignment);
float getCaDist(Alignment, int, int, int);
void getGapStats(Alignment); // Msa
void pairToMult(Alignment pw, Alignment *msa);
void multToPair(Alignment msa, Alignment *pw);

// convert between types
float charToFloat(char *);
int charToInt(char *);
char* intToString(int, int);
char* charToString(char);
char* lower(char*);

#endif
