%Graphing molecular phylogenetic tree using cluster analysis of similarity matrix 
%
%This is an example of use of clustering algorithms
%in the Statistics toolbox of Matlab
%Read in the similarity matrix of sequence simularity for 6 proteins, 
%distM.dat for example,into Matlab
load distM.dat
%Form matrix of 1-Similarity 
dM=1-distM;
%The vector of pdb names for the proteins to be used for graphing  
l={'1eqr','1ati','1adj','1efw','1asz','1b8a','1bbw'};
%Construct phylogenetic representation of this data using the clustering and dendrogram algorithms.
%To use the 'linkage' command of Matlab, one need to form a column vector of the non-redundant 
%elements above the main diagonal of the distance matrix, 
%e.g. [(1,2) (1,3) ...(5,6)]', 
d=[dM(2:7,1);dM(3:7,2);dM(4:7,3);dM(5:7,4);dM(6:7,5);dM(7:7,6)];
%Note d is a column vector
%Create hierarchical cluster tree using average distance between cluster elements 
z1=linkage(d','average');
%For more choices of distances see A. R. Leach, Molecular Modeling book and type
%'help linkage' in Matlab window
%Display dentrogram
h101=figure(101);
dendrogram(z1);
%Use the pdb code as tick labels for the x-axis
hx=get(get(h101,'CurrentAxes'),'XTickLabel');
for i=1:size(hx,1)
   hx(i)=str2double(hx(i));
end
set(get(h101,'CurrentAxes'),'XTickLabel',[l(hx(1)), ...
         l(hx(2)),l(hx(3)),l(hx(4)),l(hx(5)),l(hx(6)),l(hx(7))])
figure(h101);
title('Molecular Phylogenetic Tree');
xlabel('Protein (pdb code)')
ylabel('1-Similarity (%)')
