# VMD script to extract from the dcd file:
# (1) minimum donor-acceptor distance between D274 and K46, and
# (2) number of water molecules in the periplasmic part of the lumen of GlpT

mol new ../../../system/glpt.psf
mol addfile smd.dcd type dcd first 0 last -1 step 1 filebonds 1 autobonds 1 waitfor all

set D274_OD1 [atomselect 0 "protein and resid 274 and name OD1"]
set D274_OD2 [atomselect 0 "protein and resid 274 and name OD2"]
set K46_NZ [atomselect 0 "protein and resid 46 and name NZ"]

set num_steps [molinfo 0 get numframes]

for {set frame 0} {$frame < $num_steps} {incr frame} {
    set com [measure center [atomselect 0 "protein" frame $frame]]
    set x0 [lindex $com 0]
    set y0 [lindex $com 1]
    set z0 [lindex $com 2]
    set wat [atomselect 0 "water and noh and (x-x0)**2+(y-y0)**2<100 and z > z0 and z < z0+18" frame $frame]
    $D274_OD1 frame $frame
    $D274_OD2 frame $frame
    $K46_NZ frame $frame

    set d1 [veclength [vecsub [measure center $K46_NZ] [measure center $D274_OD1]]]
    set d2 [veclength [vecsub [measure center $K46_NZ] [measure center $D274_OD2]]]

    puts stderr "$frame [expr min($d1,$d2)] [$wat num]"
}

quit

