mol new ../../../system/glpt.psf
for {set i 0} {$i < 4} {incr i} {
    for {set j 0} {$j < 5} {incr j} {
	set k [expr $i*5+$j]
	mol addfile ../../output/$i/glpt.job0.$k.dcd type dcd first 0 last -1 step 1 filebonds 1 autobonds 1 waitfor all
    }
}

set D274_OD1 [atomselect 0 "protein and resid 274 and name OD1"]
set D274_OD2 [atomselect 0 "protein and resid 274 and name OD2"]
set K46_NZ [atomselect 0 "protein and resid 46 and name NZ"]

set num_steps [molinfo 0 get numframes]

for {set frame 0} {$frame < $num_steps} {incr frame} {
    $D274_OD1 frame $frame
    $D274_OD2 frame $frame
    $K46_NZ frame $frame

    set d1 [veclength [vecsub [measure center $K46_NZ] [measure center $D274_OD1]]]
    set d2 [veclength [vecsub [measure center $K46_NZ] [measure center $D274_OD2]]]

    puts stderr "$frame [expr min($d1,$d2)]"
}

quit

