#!/bin/bash

ni=4 # number of images
nc=5 # number of copies
nr=$((ni*nc)) # number of replicas
# pick the right directory
output="../../output"
#output="../../sample-output"

rm colvars/*
rm hist/*

for r in `seq 0 $((nr-1))`
do
    c=$((r % nc))
    i=$((r / nc))
    grep -v "#" $output/$i/glpt.job0.$r.colvars.traj | uniq | \
    awk -v c=$c '$1>0{printf "%s %s",$1,c; for(cv=0;cv<12;cv++) printf " %s %s %s %s",$(9*cv+3),$(9*cv+5),$(9*i+7),$(9*cv+9);printf"\n"}' | awk '!t||t!=$1{print;t=$1}' >> colvars/$i # reports time, copy id, and colvar values
    grep -v "#" $output/$i/glpt.job0.$r.history | uniq | \
    awk -v c=$c -v nc=$nc '{print $1,c,int($2/nc)}' >> hist/$i # reports time, copy id, and actual image id
done

rm cvs.txt
for i in `seq 0 $((nr/nc-1))`
do
    paste hist/$i colvars/$i | awk '($1==$4)&&($2==$5){printf "%s %s %s",$1,$2,$3; for(i=6;i<=NF;i++) printf " %s",$i; printf "\n"}' >> cvs.txt
done
