#!/bin/bash

#vmd -dispdev text -e analyze.tcl 2> analyze.txt

gnuplot << EOF

set size 1.2, 1.2
set terminal postscript eps solid color enhanced lw 3.0 "Times-Roman" 42

set encoding iso_8859_1

set key top left

set output "colvar.ps"
set xlabel "t (ns)"
set ylabel "spinAngle (degrees)"
plot "smd.colvars.traj" u (\$1/500000):2 w l lt 1 t "N domain", \
"smd.colvars.traj" u (\$1/500000):3 w l lt 3 t "C domain", \
20*x/4 t "schedule" lt 0 lc -1, -20*x/4 lt 0 lc -1 t ""

set yrange [0:]
set output "work.ps"
set ylabel "work (kcal/mol)"
plot "smd.colvars.traj" u (\$1/500000):4 w l lt -1 t ""

set yrange [0:]
set output "saltbridge.ps"
set ylabel "K46-D274 Distance (\305)"
plot "analyze.txt" u (\$1/200):2 w l lt -1 t ""

set yrange [0:]
set output "water.ps"
set ylabel "Water Count"
plot "analyze.txt" u (\$1/200):3 w l lt -1 t ""


EOF

for i in colvar work saltbridge water
do
epstopdf $i.ps; rm $i.ps
done
