#######################################  Laura Joana SILVA LOPES, Mar 2017 #######################################
#
# Smart script to keep a constant number of processes running to occupy all the processors on the node
# This script was made to run  parallel AMS instances
# Usage: smart_parallel conffile
#
# This script runs the for_smart script for each AMS instance!
# For more details read the README file
#
##################################################################################################################
#! /bin/bash
source $toall_smart
if [ -z $1 ]; # no input file
then
        echo "Need help?"
        cat $smart_help
        kill $$
fi
echo "starting smart";date
echo "PID" $$
lruntime=`date +%s`
export prefix="replicas"
 # prefix name for everything... maybe we can let the user choose that...
############## getting user parameters ###############
source $1
# check if all the parameters were defined
declare -a lista
lista=(numinst parallel outdir amstype numrep icprefix zone measure variables charmrunp zmax initfile timelimit amssteptime tokill getpaths removefiles)
numlista=${#lista[@]}
for((i=0;i<numlista;i++)){
	if [ -z "${!lista[$i]}" ];
	then
		>&2 echo "${lista[$i]} not defined"
		kill $$
	else
		eval export ${lista[$i]}
	fi
}
if [ $amstype == "var" ];
then
	if [ -z "$zmin" ];
	then
	        >&2 echo "zmin not defined"; kill $$
	else
		export zmin
	fi
fi
export parent=$outdir
if [ -z "$charmrunp" ] || [ $charmrunp == "0" ];
then
        export namdcommand=$namd
else
        export namdcommand="charmrun ++local +p$charmrunp $namd"
fi
unset list
######################################################
# creating output directory or arranging old runs
tudo=0
acabou=0
#redo=0
export pathlist=$parent"/paths_list"
if [ ! -d $parent ]; then
	mkdir $parent
else
	# what is already done ?
	# make a list of done procs
	declare -a doneproc
	for((i=0;i<numinst;i++)){
		analfile=${parent}"/inst."$(printf "%04d" $i)"/analysis"
		if [ -e "$analfile" ];
		then
			doneproc[$tudo]=$i
			let "tudo=tudo+1"
		fi
	}
	let "ult=tudo-1"
	if [ ${#doneproc[@]} -eq $numinst ];
	then
		echo "Attention ! This is all done !"
		kill $$
	fi
	if [ $ult -gt -1 ];
	then
		if [ ${doneproc[$ult]} -gt $ult ]; # need to arrange
		then
			ind=-1
			# arrange done procs
			indice=$ult
			for((i=0;i<numinst;i++)){
				logfile=${parent}"/inst."$(printf "%04d" $i)"/finalrun.ams.log"
				if [ ! -e "$logfile" ]; # finding holes
				then
					if [ ${doneproc[$indice]} -gt $ult ];
					then
						locdir=${parent}"/inst."$(printf "%04d" $i)
						sourcedir=${parent}"/inst."$(printf "%04d" ${doneproc[$indice]})
						mv $sourcedir $locdir
						sed -i 's/'$sourcedir'/'$locdir'/g' $pathlist
						let "indice=indice-1"
					else
						i=$numinst
					fi
				fi
			}
			# arrange repair procs
			let "jnd=tudo"
			while [ $ind -gt -1 ];
			do
				sourcedir=${parent}"/inst."$(printf "%04d" $ind)
				locdir=${parent}"/inst."$(printf "%04d" $jnd)
				mv $sourcedir $locdir
				sed -i 's/'$sourcedir'/'$locdir'/g' $pathlist
				changeset $locdir/ams.conf AMS_sharedDataPrefix $locdir/replicas
				changepar $locdir/ams.conf outputname $locdir/finalrun
				let "jnd=jnd+1"
				let "ind=ind-1"
			done
		fi
	fi
	unset doneproc
fi
acabou=$tudo
#####################################################################################
# running the first processes
if [ $parallel -gt $numinst ];
then
	parallel=$numinst
fi
let "falta=numinst-acabou"
if [ $falta -lt $parallel ];
then
	parallel=$falta
fi
for((i=0;i<parallel;i++));
do
	thisdir=$parent"/inst."$(printf "%04d" $tudo)
	if [ ! -d $thisdir ]; then
		mkdir $thisdir
	fi
	logfile=$thisdir"/smart.log"
	mycom="$smart_runams $tudo &>> $logfile &"
	eval $mycom
	see[$i]=$logfile
	echo "running AMS instance $tudo"
	let "tudo=tudo+1"
	sleep 2
done

# checking the processes I'm running and run new ones to keep the total number stable
probafile=$parent".proba"
timefile=$parent".runtime"
cputimefile=$parent".cputime"
timeT3file=$parent".T3"
if [ $amstype == "var" ];
then
        timeT1file=$parent".T1"
        timeT2file=$parent".T2"
fi
timetocheck=10 # sleep time to check the processes
while [ $acabou -lt $numinst ];
do
	for((i=0;i<parallel;i++));
	do
		if [ -n "${see[$i]}" ];
		then
			if [ -n "`grep "acabou" ${see[$i]}`" ];
			then
				let "acabou=acabou+1"
				grep "pAMS" ${see[$i]} | awk '{print $2}' >> $probafile
				grep "walltime" ${see[$i]} | awk '{print $2}' >> $timefile
				grep "cputime" ${see[$i]} | awk '{print $2}' >> $cputimefile
				grep "T3" ${see[$i]} | awk '{print $2}' >> $timeT3file
				pathfile=`grep "pathfile" ${see[$i]} | awk '{print $2}'`
				if [ -n "$pathfile" ];
				then
					cat $pathfile >> $pathlist
				fi
				if [ $amstype == "var" ];
				then
					grep "T1" ${see[$i]} | awk '{print $2}' >> $timeT1file
					grep "T2" ${see[$i]} | awk '{print $2}' >> $timeT2file
				fi
				if [ $tudo -lt $numinst ];
				then
					thisdir=$parent"/inst."$(printf "%04d" $tudo)
					if [ ! -d $thisdir ]; then
						mkdir $thisdir
					fi
					logfile=$thisdir"/smart.log"
					mycom="$smart_runams $tudo &>> $logfile &"
					eval $mycom
					see[$i]=$logfile
					echo "running AMS instance $tudo"
					let "tudo=tudo+1"
					sleep 2
				else
					see[$i]=""
				fi
			fi
		fi
	done
	sleep $timetocheck
done
echo "All $numinst AMS instances finished!"
echo "All done! =)";date
let "lruntime=`date +%s`-lruntime"
echo "total runtime: $lruntime s (`$smart_tempo $lruntime`)"
