#!/usr/bin/env tclsh
# Modified by Laura SILVA LOPES
# Script to compute the average length of iteration

# modified by Laura SILVA LOPES ###################################
# need to pass:
# amsdir = directory with ams result
# outdir = output dir
# Usage: terationTime.tcl -amsdir <amsdir> -outdir <outdir>

# parse flags
foreach {flag val} $argv { set [string range $flag 1 end] $val }

set amsLogGlobPattern "*.ams.log"
set outDir $outdir
set outputFilename "iterationTime.dat"
############################################################### end

# SCRIPT (do no modify below here)

# find all of the ams log files (modified)
set logList [lsort -dictionary -increasing [glob -directory $amsdir $amsLogGlobPattern]]

# cycle through each log file
set iterData {}
foreach log $logList {
	set infile [open $log r]
	while { ![eof $infile] } {
		set inline [string trim [gets $infile]]

		# simulation is initialized
		if { [string match "*AMS: starting system.*" $inline] } {
			set iter [scan [lindex $inline 8] %d]
			set initZ [lindex $inline 12]
		}

		# simulation is terminated
		if { [string match "*AMS: Termination criteria met at*" $inline] } {
			set stepcount [string range [lindex $inline 8] 1 end]
			lappend iterData [list $iter $initZ $stepcount]
		}
	}
	close $infile
}

# setup output (modified)
set outfile [open [file join $outDir $outputFilename] w]
puts $outfile "# Iteration\tStep Count"
foreach ele [lsort -increasing -integer -index 0 $iterData] {
	lassign $ele i z s
	# lets only include the iteration and step count right now
	# could include the initZ if desired
	puts $outfile "$i\t$s"
}
close $outfile

# note that we could also compute some summary stats, e.g., average length
