#######################################  Laura Joana SILVA LOPES, Apr 2016 #######################################
# script to calculate T3 medium value, standard deviation and make a file to plot an histogram
# usage: histogram.tcl -outdir <out dir> -forfile <forhistogram file> -num <number of intervals>
##################################################################################################################

# parse flags
foreach {flag val} $argv { set [string range $flag 1 end] $val }

set infile [open $forfile r]
set outfile [open [file join $outdir histogram.dat] w]
set med 0
set stddev 0
set total 0
set data {}
while {-1 != [gets $infile val]} {
        incr total
        set med [expr $med + $val]
        set stddev [expr $stddev + $val*$val]
        append data " " $val
}
set med [expr $med / $total]
set stddev [expr sqrt(($stddev/$total - $med*$med)/$total)]
puts $outfile "# Mean: $med Stddev: $stddev"
set orgdata [lsort -real $data]
set max [lindex $orgdata [expr $total-1]]
set min [lindex $orgdata 0]
set int [expr ($max-$min)/$num]
set ind 0
set val [lindex $orgdata $ind]
set lim $min
puts $outfile "# center\tfreq"
for { set i 1 } { $i < $num } { incr i } {
        set hist 0
        set lim [expr $lim+$int]
        while { $val < $lim } {
                incr hist
                incr ind
                set val [lindex $orgdata $ind]
        }
        puts $outfile "[expr $lim-$int/2]\t$hist"
}
set hist 0
while { $val <= $max && $ind < $total } {
        incr hist
        incr ind
        set val [lindex $orgdata $ind]
}
puts $outfile "[expr $max-$int/2]\t$hist"
close $infile
close $outfile
