#! /bin/bash

## USER settings ##
prefix=`echo $1 | rev | cut -d'/' -f1 | rev`
outdir=$2
###################

forpathdir=$outdir"/paths"
if [ -d $forpathdir ];
then
	rm -r $forpathdir
fi
mkdir $forpathdir

# getting number of variables
file2=($(head -1 $outdir/${prefix}.sys | tr -s '{}' '\n' | grep $prefix | awk '{print $1}' | head -1))
test=`echo $file2 | grep "/"`
if [ -n "$test" ];
then
	file=$file2.traj
else
	file=$outdir/$file2.traj
fi
nvar=($(tail -1 $file | awk '{print NF-1}'))

logfile=$outdir"/finalrun.ams.log"
# getting paths
inB=($(grep "sysId" $logfile | grep "reached" | awk '{print $4}' | sort -n))
let "totalnum=${#inB[@]}"
for((k=0;k<totalnum;k++))
do
	declare -a file maxstep
	outfile=${forpathdir}"/"${prefix}"."$(printf "%06d" $k)".dat"
	let "rep=inB[k]+1"
	file=($(sed ''$rep'!d' $outdir/${prefix}.sys | tr -s '{}' '\n' | grep $prefix | awk '{print $1}'))
	maxstep=($(sed ''$rep'!d' $outdir/${prefix}.sys | tr -s '{}' '\n' | grep $prefix | awk '{print $2}'))
	let "num=${#file[@]}"
	initialstep=0
	jini=0
	echo $outfile >> $outdir/pathlist
	for((i=0;i<num;i++))
	do
		test=`echo ${file[$i]} | grep "/"`
		if [ -n "$test" ];
		then
			trajfile=${file[$i]}.traj
		else
			trajfile=$outdir/${file[$i]}.traj
		fi
		declare -a step variables
		step=($(awk '{print $1}' $trajfile))
		variables=($(awk '{print substr($0,index($0,$2))}' $trajfile))
		let "nums=${#step[@]}"
		if [ $i -eq 1 ];
		then
			jini=1
		fi
		for((j=jini;j<nums;j++))
		do
			if [ ${step[$j]} -le ${maxstep[$i]} ];
			then
				let "realstep=initialstep+step[j]"
				echo -ne "$realstep" >> $outfile
				for((l=0;l<nvar;l++))
				do
					let "ind=j*nvar+l"
					echo -ne "\t${variables[$ind]}" >> $outfile
				done
				echo >> $outfile
			fi
		done
		initialstep=$realstep
		unset step variables
	done
	unset file maxstep
done
