package provide Marshmallow 1.0


namespace eval ::Marshmallow:: {
}


proc marshmellify {{mol top}} {
  ::Marshmallow::make_marshmallow $mol chain
}



proc ::Marshmallow::make_marshmallow {mol attribute} {

  set pieces [lsort -unique [[atomselect $mol "protein or nucleic"] get $attribute]]
  
  set index 0
  
  foreach piece $pieces {
  
  if {1} {
    # MEDIUM DETAIL
    set sel [atomselect $mol "(protein or nucleic) and ($attribute $piece)"]
    volmap density $sel -res 1.5 -radscale 4 -weight radius -mol $mol
    
    # create new rep:
    #mol color ColorID [expr ($index)%32]
    mol color ColorID [expr ([$sel num])%32]
    mol rep Isosurface 0.06 $index 0 0 1 
    mol selection "$attribute $piece"
    mol material Opaque
    mol addrep $mol
    $sel delete
  } else { 
  
     # LOW DETAIL
     set sel [atomselect $mol "(protein or nucleic) and ($attribute $piece)"]
     volmap density $sel -res 4 -radscale 8 -weight mass -mol $mol
     
    # create new rep:
    #mol color ColorID [expr ($index)%32]
    mol color ColorID [expr ([$sel num])%32]
    mol rep Isosurface 0.15 $index 0 0 1 
    mol selection "$attribute $piece"
    mol material Opaque
    mol addrep $mol
    $sel delete
  }   

      
    incr index
  }
  
}
