#ifndef SYMBOLLIST_H
#define SYMBOLLIST_H

#include "alphabet.h"
#include "symbol.h"

#include <stdio.h>

class SymbolList {
  
 public:
  SymbolList(int l, Alphabet* a, char* n);
  SymbolList(int l, Alphabet* a);
  ~SymbolList();
  
  int addSymbol(Symbol* symbol);
  int addSymbol(char c);
  int addSymbols(char* c);
  Symbol* getSymbol(int i);
  Alphabet* getAlphabet();
  const char* getName();
  int getLength();
  int getMaxLength();
  int setName(const char* n);
  int symbolsEqual(SymbolList* sl);
  int symbolsWithoutGapsEqual(SymbolList* sl);
  char* toString();

 private:
  Alphabet* alphabet;
  Symbol** list;
  char* name;
  int length;
  int maxLength;

};

#endif
