
#include "coordinate3D.h"


Coordinate3D::Coordinate3D(float a, float b, float c) {

 coords[0] = a;
 coords[1] = b;
 coords[2] = c;

  return;
}


int Coordinate3D::equals(Coordinate3D* coord) {

  if ( coord->getX() != coords[0] ||
       coord->getY() != coords[1] ||
       coord->getZ() != coords[2] ) {
    return 0;
  }
    
  return 1;
}


float Coordinate3D::getX() {

  return coords[0];
}


float Coordinate3D::getY() {
  
  return coords[1];
}


float Coordinate3D::getZ() {

  return coords[2];
}


// getDistanceTo - returns the Euclidean distance between this and coord;
//   returns -1.0 on error;
float Coordinate3D::getDistanceTo(Coordinate3D* coord) {

  if (coord == 0) {
    return -1.0;
  }

  float distance = sqrt( pow(coords[0] - coord->getX(),2) +
			 pow(coords[1] - coord->getY(),2) +
			 pow(coords[2] - coord->getZ(),2) );
  
  return distance;
}
