
#ifndef ALIGNEDSEQUENCE_H
#define ALIGNEDSEQUENCE_H

#include "sequence.h"
#include "symbol.h"
#include "symbolList.h"

#include <stdio.h>

class AlignedSequence : public Sequence {

 public:
  AlignedSequence(int l, Alphabet* a, char* n);
  AlignedSequence(int l, Alphabet* a);
  ~AlignedSequence();

  int addSymbol(Symbol* symbol);
  int addSymbol(char c);
  int addGap();

  // XXX - REDO ALL ACCESS METHODS IN UNALIGNED VERSIONS;
  //   USE THE DEFAULT PARENT METHODS FOR THE ALIGNED DATA
  const Symbol* getUnalignedSymbol(int i);
  int getUnalignedLength();
  char* unalignedToString();
  int alignedToUnalignedIndex(int i);
  int unalignedToAlignedIndex(int i);
  float getPercentIdentity(AlignedSequence *comparisonSequence);

 private:
  int* alignedToUnaligned;
  int* unalignedToAligned;
  int  unalignedLength;

};

#endif
