#!/bin/bash

ni=4 # number of images
nc=5 # number of copies
log="../output/job0.log" # list all log files
#log="../sample-output/job0.log" # if you are using the sample-output

grep EXCHANGING $log | awk -v ni=$ni -v nc=$nc '{
    count[$8]++
    nr=$6+1
}END{
    for(i=0;i<ni-1;i++) print i,count[i]/(nr*nc/2),nr
}' | sort -n | \
awk 'BEGIN{
    print "#image1 image2 rate(percentage)"
}{
    sum+=$2
    n++
    print $1,$1+1,100*$2
    nr=$3
}END{
    print "#avr",100*sum/n
    print "#runs",nr
}' > exchange.txt
