#!/bin/bash

gnuplot << EOF

set size 1.2, 1.2
set terminal postscript eps solid color enhanced lw 3.0 "Times-Roman" 42

set key top left

set output "colvar.ps"
set xlabel "t (ns)"
set ylabel "2 acos(q_0) (degrees)"
plot "smd.colvars.traj" u (\$1/500000):(2*180*acos(\$3)/pi) w l lt 1 t "N domain", \
"smd.colvars.traj" u (\$1/500000):(-2*180*acos(\$12)/pi) w l lt 3 t "C domain", \
20*x/4 t "schedule" lt 0 lc -1, -20*x/4 t "" lt 0 lc -1

set yrange [0:]
set output "work.ps"
set ylabel "work (kcal/mol)"
plot "smd.colvars.traj" u (\$1/500000):20 w l lt -1 t ""

EOF

for i in colvar work
do
epstopdf $i.ps; rm $i.ps
done
