##################################################################
#
#  The subroutines.
#
##################################################################

global rms_ave rms_list pdb_list
global bb_only align_sel rms_sel rmsd_base tot_rms

proc molactive {} {

    set mol_active_list {}
    set all_mols [molinfo list]
    
    foreach i $all_mols  {
	if { [molinfo $i get active] } {
	    set mol_active_list [concat $mol_active_list $i]
	}
    }

    return $mol_active_list
}

proc align { sel1 sel2 } {

# tries to align sel1 with sel2, using the atoms of each selection.
# If sel1 and sel2 contain a different number of atoms, it fails.

    set tmatrix [measure fit $sel1 $sel2]
    set molid [$sel1 molid]
    set move_sel [atomselect $molid "all"]
    $move_sel move $tmatrix
    return $tmatrix
}


proc align_all {sel_text} {

    set all_mols [molactive]
    
    foreach i $all_mols  {
	set sel($i) [atomselect $i $sel_text]
    }
    
    set mol_on_top [molinfo top]
    
    foreach i $all_mols  {
	if { $i != $mol_on_top } {
	    align $sel($i) $sel($mol_on_top)
	}
    }
    
}


proc get_rmsd { mol1 mol2 sel_text } {
    
    set sel1 [atomselect $mol1 $sel_text] 
    set sel2 [atomselect $mol2 $sel_text]
    measure rmsd $sel1 $sel2
}


proc ini_zero {length} {
    if {$length<=0} return {}

    set half_l [expr $length>>1]
    set s {{0 0 0}}
    for {set i 1} {$i<$half_l} {set i [expr $i<<1]} {
	set s [concat $s $s]
    }

    set more [expr $length-$i-1]
    set s [concat $s [lrange $s 0 $more]]

    return $s
}


proc ave_struc {sel_text} {

    set all_mols [molactive]
    set n_mols [molinfo num]
    set factor [expr 1./$n_mols]
    
    foreach i $all_mols {
	set all_coor($i) [[atomselect $i $sel_text] get {x y z}]
    }

    set ave_coor {}
    set m0 [lindex $all_mols 0]
    set len [llength $all_coor($m0)]

    for {set j 0} {$j<$len} {incr j} {
	set b [veczero]
	foreach i $all_mols {
	    set b [vecadd $b [lindex $all_coor($i) $j]]
	}
	lappend ave_coor [vecscale $b $factor]
    }

    return $ave_coor
}


proc compute_rms {base sel_text} {
    global rms_ave

    set all_mols [molactive]
    set mol_on_top [molinfo top]
    set n_mols [molinfo num]
    set factor [expr 1./$n_mols]
    
    foreach i $all_mols {
	set all_coor($i) [[atomselect $i $sel_text] get {x y z}]
    }
    
    switch $base {
	top {
	    set ave_coor $all_coor($mol_on_top)
	    set len [llength $ave_coor]
	}
	ave {
	    set ave_coor {}
	    set m0 [lindex $all_mols 0]
	    set len [llength $all_coor($m0)]

	    for {set j 0} {$j<$len} {incr j} {
		set b [veczero]
		foreach i $all_mols {
		    set b [vecadd $b [lindex $all_coor($i) $j]]
		}
		lappend ave_coor [vecscale $b $factor]
	    }
	}
    }

    set tot_rms 0
    foreach i $all_mols {
	set r 0
	for {set j 0} {$j<$len} {incr j} {
	    set v1 [lindex $ave_coor $j]
	    set v2 [lindex $all_coor($i) $j]
	    set r [expr $r + [veclength2 [vecsub $v1 $v2]]]
	}
	set r [expr $r/$len]
	set tot_rms [expr $tot_rms + $r]
	set rms_ave($i) [expr sqrt($r)]
#	set tot_rms [expr $tot_rms + $rms_ave($i)]
    }

#    set tot_rms [expr $tot_rms/$n_mols]
    set tot_rms [expr sqrt($tot_rms/$n_mols)]

    return $tot_rms
}


proc reveal_rms {} {
    global rms_ave rms_list pdb_list

    set all_mols [molactive]

    set n [$pdb_list index end]
    for {set j 0} {$j<$n} {incr j} {
	$pdb_list delete end
    }

    set n [$rms_list index end]
    for {set j 0} {$j<$n} {incr j} {
	$rms_list delete end
    }

    foreach i $all_mols {
	$pdb_list insert end [molinfo $i get name]
	$rms_list insert end $rms_ave($i)
    }

}


##################################################################
#
#  The Aligner.
#
##################################################################

#
#  Set several parameters.

set ftr_bgcol \#2a4
set ftr_fgcol \#ff0
set bb_only(0) 1
set align_sel {name CA}


##########################################################
#
# Create the selection window for the RMSD alignment.
#
toplevel .fitter -bg $ftr_bgcol
wm title .fitter "RMS Alignment"

#
# Make up a selection window + the "Align" button.
#
frame .fitter.left -bg $ftr_bgcol

frame .fitter.left.selfr -relief sunken -bd 4 -bg $ftr_bgcol
entry .fitter.left.selfr.sel -bd 0 -highlightthickness 0 -insertofftime 0 \
    -bg \#a64da6 -selectbackground \#333 -selectforeground \#ccc \
    -selectborderwidth 0 -exportselection yes \
    -textvariable align_sel
bind .fitter.left.selfr.sel <Return> { if { $bb_only(0) } \
					   {align_all [concat "(" $align_sel ") and backbone"]} \
					   else {align_all $align_sel} }

checkbutton .fitter.left.bb -highlightthickness 0 \
    -activebackground $ftr_bgcol -bg $ftr_bgcol \
    -activeforeground $ftr_fgcol -fg $ftr_fgcol  \
    -text {Backbone only} -variable bb_only(0)

button .fitter.push -relief raised -bd 4 -highlightthickness 0 -text {Align} \
    -activebackground \#0b4 -bg \#183 \
    -activeforeground \#f00 -fg $ftr_fgcol  \
    -command { if { $bb_only(0) } \
		   {align_all [concat "(" $align_sel ") and backbone"]} \
		   else {align_all $align_sel} }

#
# Pack the widgets.
#
pack .fitter.left -side left -fill both -expand 1
pack .fitter.push -side left -fill both

pack .fitter.left.selfr -side top -fill both -expand 1 -padx 4 -pady 4
pack .fitter.left.bb -side top -fill both

pack .fitter.left.selfr.sel -side top -fill both -expand 1


##################################################################
#
#  The Calculator.
#
##################################################################

#
#  Set several parameters.
set calc_bgcol \#24a
# \#d9d9d9
set calc_fgcol \#ff0
# \#333
set bb_only(1) 1
set rms_sel {name CA}
set rmsd_base {top}
set tot_rms {}

##########################################################
#
# Create the window for the RMSD calculations.
#
toplevel .calculator -bg $calc_bgcol
wm title .calculator "RMSD Calculator"

#
# Create the top part with selection windows and 
# the "Calculate" button
#
set calc_top [frame .calculator.top -bg $calc_bgcol]

#
# Selection part.

frame $calc_top.left -relief ridge -bd 4 -bg $calc_bgcol
set rc_win [frame $calc_top.left.inner -bg $calc_bgcol -bd 0]
frame $rc_win.selfr -relief sunken -bd 4 -bg $calc_bgcol

entry $rc_win.selfr.sel -bd 0 -highlightthickness 0 -insertofftime 0 \
    -bg \#a64da6 -selectbackground \#333 -selectforeground \#ccc \
    -selectborderwidth 0 -exportselection yes \
    -textvariable rms_sel

bind $rc_win.selfr.sel <Return> { \
      if { $bb_only(1) } { \
	  set tot_rms [compute_rms $rmsd_base [concat "(" $rms_sel ") and backbone"]] \
      } else { \
	  set tot_rms [compute_rms $rmsd_base $rms_sel]}; \
      reveal_rms  }

checkbutton $rc_win.bb -highlightthickness 0 \
    -activebackground $calc_bgcol -bg $calc_bgcol \
    -fg $calc_fgcol -activeforeground $calc_fgcol \
    -text {Backbone only} -variable bb_only(1)


#
# Button part.

frame $calc_top.right -bg $calc_bgcol

##
frame $calc_top.right.pushfr -relief ridge -bd 4 -bg $calc_bgcol

button $calc_top.right.push -relief raised -bd 4 -highlightthickness 0 -text {RMSD} \
    -activebackground \#26c -bg \#338 \
    -fg $calc_fgcol -activeforeground $calc_fgcol \
    -command { \
      if { $bb_only(1) } { \
	  set tot_rms [compute_rms $rmsd_base [concat "(" $rms_sel ") and backbone"]] \
      } else { \
	  set tot_rms [compute_rms $rmsd_base $rms_sel]}; \
      reveal_rms  }

##
frame $calc_top.right.switch -bg $calc_bgcol -relief ridge -bd 4

radiobutton $calc_top.right.switch.0 -highlightthickness 0 \
    -activebackground $calc_bgcol -bg $calc_bgcol \
    -fg $calc_fgcol -activeforeground $calc_fgcol \
    -text {Top} -variable rmsd_base -value "top"

radiobutton $calc_top.right.switch.1 -highlightthickness 0 \
    -activebackground $calc_bgcol -bg $calc_bgcol \
    -fg $calc_fgcol -activeforeground $calc_fgcol \
    -text {Average} -variable rmsd_base -value "ave"


#
# Pack the top part widgets.

pack $calc_top -side top -fill both -expand 1 

### ...selection...
pack $calc_top.left -side left -fill both -expand 1
pack $rc_win -side left -fill both -expand 1

pack $rc_win.selfr -side top -fill both -expand 1 -padx 4 -pady 4
pack $rc_win.bb -side top -fill both

pack $rc_win.selfr.sel -side top -fill both -expand 1

### ...button...
pack $calc_top.right -side left -fill both

pack $calc_top.right.pushfr -side top -fill both -expand 1
pack $calc_top.right.push -side top -fill both -expand 1 -in $calc_top.right.pushfr
pack $calc_top.right.switch -side top -fill both

#pack $calc_top.right.switch.from $calc_top.right.switch.frame -side top -fill both
#pack $calc_top.right.switch.frame -side top -fill both
pack $calc_top.right.switch.0 $calc_top.right.switch.1 \
    -side left -fill both -padx 2 -pady 2


#
# Create the bottom part, displaying the RMSDs of
# all the molecules from the average structure.
#

set calc_mid [frame .calculator.middle -relief ridge -bd 4 -bg $calc_bgcol]

label $calc_mid.title -text {RMS deviations:} -relief raised -bd 2 \
    -bg $calc_bgcol -fg $calc_fgcol \
    -padx 3 -pady 3
set rms_disp [frame .calculator.middle.body -bg $calc_bgcol]

frame $rms_disp.left -bg $calc_bgcol -bd 0
frame $rms_disp.right -bg $calc_bgcol -bd 0

set pdb_list [listbox $rms_disp.pdb_names -relief raised -bd 2 -height 10 \
		  -bg $calc_bgcol -fg $calc_fgcol \
		  -highlightthickness 0 -highlightbackground $calc_bgcol \
		  -yscrollcommand "$rms_disp.scrbar set"]
set rms_list [listbox $rms_disp.rms_values -relief raised -bd 2 -height 10 \
		  -bg $calc_bgcol -fg $calc_fgcol  \
		  -highlightthickness 0 -highlightbackground $calc_bgcol \
		  -yscrollcommand "$rms_disp.scrbar set"]

set all_mols [molactive]
foreach i $all_mols {
    $pdb_list insert end [molinfo $i get name]
    set rms_ave($i) {}
    $rms_list insert end $rms_ave($i)
}

set rmstot_lbl [label $rms_disp.rmstot_lbl -text {Total RMSD:} -anchor w -pady 3 \
		    -bg $calc_bgcol -relief raised -bd 2 -fg $calc_fgcol]
set rmstot_val [label $rms_disp.rmstot_val -textvariable tot_rms -anchor w -pady 3 \
		    -bg $calc_bgcol -relief raised -bd 2 -fg $calc_fgcol]

proc two_scroll args {
    global pdb_list rms_list
    eval $pdb_list yview $args
    eval $rms_list yview $args
}

scrollbar $rms_disp.scrbar \
    -relief raised -activerelief raised -bd 2 -elementborderwidth 2 \
    -bg $calc_bgcol -troughcolor \#126 -highlightthickness 0 -activebackground \#26c \
    -orient vert -command "two_scroll"

#
# Pack the bottom part widgets.
#

pack $calc_mid -side top -fill both -expand 1
# -padx 2 -pady 2
pack $calc_mid.title -side top -fill x

pack $rms_disp -side top -expand 1 -fill both

pack $rms_disp.left $rms_disp.right -side left -fill both -expand 1
pack $rms_disp.scrbar -side left -fill y

pack $pdb_list -side top -fill both -expand 1 -in $rms_disp.left
pack $rmstot_lbl -side top -fill x -in $rms_disp.left

pack $rms_list -side top -fill both -expand 1 -in $rms_disp.right
pack $rmstot_val -side bottom -fill x -in $rms_disp.right


