import unittest
from VMD import display 

class displayTestCase(unittest.TestCase):
  def setUp(self):
    pass

  def tearDown(self):
    pass

  def testUpdate(self):
    display.update()

  def testUpdateUI(self):
    display.update_ui()

  def testUpdateOnOff(self):
    display.update_off()
    display.update_on()

  def testSetGet(self):
    mydict={
      'eyesep' : 1.0,
      'focallength' : 4.0,
      'height' : 2.0,
      'distance' : 3.0,
      'nearclip' : 1.0,
      'farclip' : 8.0,
      'antialias' : 0,
      'depthcue' : 1,
      'culling' : 1,
      'stereo' : display.stereomodes()[-1],
      'projection' : display.PROJ_PERSP,
      'size' : [400,400]
      }
    display.set(**mydict)
    for key,val in mydict.items():
      self.failUnlessEqual(display.get(key), val)

if __name__=="__main__":
  unittest.main()
