
import atomselection

def macro(*args, **keywds):
	return apply(atomselection.macro, args, keywds)

class AtomSel:
	def __init__(self, selection='all', molid=0, frame=0):
		self.__molid = molid
		self.__text = selection
		self.__frame = frame
		self.__list = atomselection.create(molid, frame, selection)
	def select(self, selection):
		self.__list = atomselection.create(self.__molid, self.__frame,\
			selection)
		self.__text = selection
	def molid(self):
		return self.__molid
	def frame(self, value=-1):
		if value >= 0:
			self.__frame = value
			return self
		else:
			return self.__frame
	def get(self, *attrlist):
		result = [] 
		for attr in attrlist:
			result.append(atomselection.get( \
				self.__molid, self.__frame, self.__list, attr))
                if len(result) == 1:
			result = result[0]
		return result
	def set(self, attr, val):
		valtype = type(val)
		if valtype == type('') or valtype == type(1) or \
			valtype == type(1.0): 
			atomselection.set( self.__molid, self.__frame, \
				self.__list, attr, (val,))
		elif valtype == type([]) or valtype == type(()):
			atomselection.set(self.__molid, self.__frame, \
				self.__list, attr, tuple(val))
		else:
			raise AttributeError
	def getbonds(self):
		return atomselection.getbonds(self.__molid, self.__list)
	def setbonds(self, bonds):
		return atomselection.setbonds(self.__molid, self.__list, bonds)

	def minmax(self):
		return atomselection.minmax(self.__molid, self.__frame, self.__list);

	def rmsd(self,sel=None, frame=None, weight=None):
		if sel is None:
			sel = self
		if frame is None:
			frame = sel.__frame
		return atomselection.rmsd(self.__molid, self.__frame, self.__list, sel.__molid, frame, sel.__list, weight)

	def contacts(self, cutoff, sel = None):
		if sel is None:
			sel = self
		if sel.__molid != self.__molid or sel.__frame != self.__frame:
			raise ValueError, "sel must have same molid and frame as selection"
		return atomselection.contacts(self.__molid, self.__frame, self.__list, sel.__list, float(cutoff))
		
	def __and__(self, other):
		newseltext = '(' + self.__text + ') and (' + other.__text + ')'
		return AtomSel(newseltext, self.__molid, self.__frame)
	def __or__(self, other):
		newseltext = '(' + self.__text + ') or (' + other.__text + ')'
		return AtomSel(newseltext, self.__molid, self.__frame)
	def __neg__(self):
		newseltext = 'not (' + self.__text + ')'
		return AtomSel(newseltext, self.__molid, self.__frame)

	def __str__(self):
		return self.__text 
	def __len__(self):
		return len(self.__list)
	def __getitem__(self, key):
		return self.__list[key]
	def __getslice__(self, low, high):
		return self.__list[low:high]
