###############################################################################
#
#  AutoIMD Settings
#
#  Use this file to help yourself configure AutoIMD and specify on which servers
#  to run your simulations.
# 
#  Copy this file to your home directory and edit its contents. Make sure that
#  it is sourced by VMD when VMD is loaded (i.e.: add "source <filename>") to
#  your .vmdrc file
#
#  Most AutoIMD variables will already have been set. You only need to override 
#  the variables that you wish to change.
#
###############################################################################


###############################################################################
### Must activate AutoIMD before using it                                   ###
###############################################################################

package require autoimd



###############################################################################
### Customize the startup AutoIMD variables                                 
###############################################################################
#
# These will modify the default behavior of AutoIMD.
#
###############################################################################


# some variables should depend on the platform...

# the directory in which all the simulation-related files are stored
## autoimd set scratchdir "$env(HOME)/autoimd"

# space-separated list of all the CHARMM param files to be used 
## autoimd set parfiles {list of files}

switch [vmdinfo arch] { 
  WIN32 {  ;# Running on MS Windows (NOT POSSIBLE YET!)
    autoimd set parfiles {c:/charmm27/par_all27_prot_lipid.inp}
    autoimd set scratchdir "c:/autoimd"
  }
  default {  ;# Running on UNIX/MacOSX
    global env
    autoimd set parfiles {/Projects/pgrayson/toppar/charmm27/par_all27_prot_lipid.inp}
    autoimd set scratchdir "$env(HOME)/autoimd"
  }
}



# and some variables don't...

# initial text molten atom selection
## autoimd set moltenseltext "atom selection"

# initial text fixed atom selection
## autoimd set fixedseltext "atom selection"

# path to a NAMD template conf file (see "template.namd" example)
## autoimd set namdtmplfile filename

# simulation temperature
## autoimd set temperature 310

# timesteps to minimize
## autoimd set minimizesteps 100

# timesteps to run
## autoimd set runsteps 1000000

# AutoIMD default graphical representations
## set autoimd set imdrep {
##    mol representation Bonds 0.300000 6.000000
##    mol color Name
##    mol selection "imdbonds and noh"
##    mol material Opaque
##    mol addrep $imdmol
##
##    mol representation VDW 1.000000 8.000000
##    mol color ColorID 4
##    mol selection "imdions"
##    mol material Opaque
##    mol addrep $imdmol
##
##    mol representation Bonds 0.300000 6.000000
##    mol color Name
##    mol selection "imdwater"
##    mol material Opaque
##    mol addrep $imdmol
##  }
  


###############################################################################
### Add server configurations                                               
###############################################################################
#
# typing: "autoimd server add <servername> <script>" will run the 
# specified script whenever <servername> is selected from the AutoIMD server
# menu. A server here is just a description of the machines and means
# used to run the simulation (currently NAMD) that will be connected to VMD.
#
###############################################################################

# This line erases the default settings and lets you start anew.
# Uncomment it if you just want to merge your own servers to the default list.
autoimd clearservers


# EXAMPLE: Run sim on the local machine
autoimd addserver "Local" {
  autoimd set hosts "localhost"
  NAMDRun::useQueuingSystem "local"
  NAMDRun::useNAMDName "/usr/local/bin/namd2"
  autoimd set maxprocs  1
  autoimd set nprocessors  1
  autoimd set namd_opts "++local"
  autoimd set connectiontimeout 30
}


# EXAMPLE: Run sim on one of four remote clusters via a DQS queue.
autoimd addserver "TCBG Cluster" {
  autoimd set hosts "umbriel oberon titania ariel"
  NAMDRun::useQueuingSystem "DQS"
  NAMDRun::useDQSResourceList beowulf.and.short
  NAMDRun::useNAMDName "/usr/local/bin/namd2"
  autoimd set maxprocs  32
  autoimd set nprocessors  12
  autoimd set namd_opts "+netpoll"
  autoimd set connectiontimeout 10
}


# EXAMPLE: Do not run NAMD, just create the files
autoimd addserver "None" {
  NAMDRun::useQueuingSystem "none"
  autoimd set maxprocs  0
  autoimd set nprocessors  0
  set AutoIMD::presubmitscript {
    setstate "uninitialized"
    set AutoIMD::statustext "Done writing files."
    return ;# this prevents loading of IMD molecule, etc.
  }
}


# Set the default server configuration 
autoimd setserver "TCBG Cluster"
