# This script compares the rmsd between frames in a trajectory with respect to the first.

#mol new 1f9j-closed-eq.psf
#mol addfile 1f9j-closed-eq.dcd waitfor all

set outfileA [open rmsd_A.dat w];
set outfileB [open rmsd_B.dat w];
set outfileC [open rmsd_C.dat w];
set outfileD [open rmsd_D.dat w];
set outfileALL [open rmsd_ALL.dat w];

set nf [molinfo top get numframes]

set A0 [atomselect top "segname A and backbone" frame 0]
set B0 [atomselect top "segname B and backbone" frame 0]
set C0 [atomselect top "segname C and backbone" frame 0]
set D0 [atomselect top "segname D and backbone" frame 0]
set ALL0 [atomselect top "protein and backbone" frame 0]

set An [atomselect top "segname A and backbone"]
set Bn [atomselect top "segname B and backbone"]
set Cn [atomselect top "segname C and backbone"]
set Dn [atomselect top "segname D and backbone"]
set ALLn [atomselect top "protein and backbone"]

# rmsd calculation loop
for {set i 0 } {$i < $nf } { incr i } {

    $An frame $i
    $Bn frame $i
    $Cn frame $i
    $Dn frame $i
    $ALLn frame $i

    puts $outfileALL "[measure rmsd $ALLn $ALL0]"

    $An move [measure fit $An $A0]
    $Bn move [measure fit $Bn $B0]
    $Cn move [measure fit $Cn $C0]
    $Dn move [measure fit $Dn $D0]
    #$ALLn move [measure fit $ALLn $ALL0]

    puts $outfileA "[measure rmsd $An $A0]"
    puts $outfileB "[measure rmsd $Bn $B0]"
    puts $outfileC "[measure rmsd $Cn $C0]"
    puts $outfileD "[measure rmsd $Dn $D0]"
    #puts $outfileALL "[measure rmsd $ALLn $ALL0]h
}

close $outfileA
close $outfileB
close $outfileC
close $outfileD
close $outfileALL


