/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: startup.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.5 $	$Date: 95/10/09 05:18:13 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Startup code for VMD ... used only by Global files, contains variables
 * and routines to read initial data files and scripts, and parse
 * command-line options.
 ***************************************************************************/
#ifndef STARTUP_VMD_H
#define STARTUP_VMD_H

/***************************************************************************
 enumerates for different initial status variables, such as the type of
 display to use at startup
 ***************************************************************************/

// display types at startup
enum DisplayTypes { DISPLAY_WIN, DISPLAY_CAVE, DISPLAY_TEXT, 
		    DISPLAY_CAVEFORMS, NUM_DISPLAY_TYPES};

// how to show the title
enum TitleTypes { TITLE_OFF, TITLE_ON, NUM_TITLE_TYPES };

/***************************************************************************
 string names for these enumerations
 ***************************************************************************/
extern char *displayTypeNames[];
extern char *titleTypeNames[];

/***************************************************************************
 initial status variables, used to control how VMD starts up
 ***************************************************************************/
extern int which_display;		  // type of display to use
extern float displayHeight, displayDist;  // height and distance of display
extern int displaySize[2], displayLoc[2]; // X,Y size and position of display
extern int showTitle;			  // how to show the title at start

/***************************************************************************
 function prototypes for startup routines
 ***************************************************************************/
extern void VMDgetEnvironment(void);
extern void VMDparseCommandLine(int, char **);
extern void VMDreadInit(void);
extern void VMDreadStartup(void);

#endif

