/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: GrabTool.C,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 95/12/18 22:30:11 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   Code for the Tool which only translates molecules
 *
 ***************************************************************************/

#include "TransTool.h"
#include "ToolControl.h"
#include "Buttons.h"
#include "CmdTrans.h"
#include "CommandQueue.h"
#include "Global.h"
#include "CmdPick.h"
#include "Mouse.h"
#include "MouseEvent.h"
#include "CommandQueue.h"
#include "Molecule.h"
#include "MoleculeList.h"

void TransTool::redraw_list(ToolInfo *info) {
  
  reset_disp_list();  // clear out everything
  
  // the default picture is a simple cylinder with a cone end
  switch (info->detail ) {
    case 1:  // draw a simple line with a cheap end
       {float tip[3]  = {1,0,0}; 
       float base[3] = {0,0,0};
       drawcolor.putdata(info -> toolid, this);  // color each tool differently
       drawline.putdata(base, tip, this);  // line
        base[0] = 0.9;
        base[1] = 0.1;
       drawcolor.putdata(info -> toolid + 1, this);
        drawline.putdata(base, tip, this);  // and tip
        base[1] = -base[1];
        drawline.putdata(base, tip, this);
        base[2] = base[1];
        base[1] = 0.0;
        drawline.putdata(base, tip, this);
        base[1] = -base[1];
        drawline.putdata(base, tip, this);}
      break;
    case 2:  // draw a cylinder with different sized radii
       draw_cylindrical_pointer(info, 3);
      break;
    case 3:
       draw_cylindrical_pointer(info, 4);
      break;
    case 4:
       draw_cylindrical_pointer(info, 6);
      break;
    case 5:
       draw_cylindrical_pointer(info, 10);
      break;
    case 6:
       draw_cylindrical_pointer(info, 16);
      break;
    case 7:  // include material characteristics
       drawmaterials.putdata(TRUE, this);
       draw_cylindrical_pointer(info, 12);
       drawmaterials.putdata(FALSE, this);
      break;
    case 8:
       drawmaterials.putdata(TRUE, this);
       draw_cylindrical_pointer(info, 12);
       drawmaterials.putdata(FALSE, this);
      break;
    case 9:
       drawmaterials.putdata(TRUE, this);
       draw_cylindrical_pointer(info, 16);
       drawmaterials.putdata(FALSE, this);
      break;
    case 10: 
       drawmaterials.putdata(TRUE, this);
       draw_cylindrical_pointer(info, 24);
       drawmaterials.putdata(FALSE, this);
      break;
    default:  // same as 5
       draw_cylindrical_pointer(info, 10);
      break;
  }
}

//
//  Cone with a 3D plus at the end
//
//  \_____           
//        \__________
//                  _\|_
//         __________/|
//   _____/
//  /

void TransTool::draw_cylindrical_pointer(ToolInfo *info, int numsides)
{
  if (numsides < 3) numsides = 3;
  if (numsides > 30) numsides = 30;
  float base[3] = {0.0,0.0,0.0};
  float tip[3] = {1.0, 0.0, 0.0};
  drawcolor.putdata(info -> toolid, this);  // color each tool differently
  drawcone.putdata(base, tip, 0.7, numsides, this);
  drawcolor.putdata(REGSILVER, this);
  linewidth.putdata(2, this);
  for (int i=0; i<3; i++) {
    float tip[2][3] = { {1.0, 0.0, 0.0}, {1.0, 0.0, 0.0} };
    tip[0][i] += .2 * (i==0 ? .25 : 1);
    tip[1][i] -= .2 * (i==0 ? .25 : 1);
    drawline.putdata(tip[0], tip[1], this);
  }
}

// Am I grabbing anything?  If so, move it
void TransTool::tool_event(ToolControl *, ToolInfo *toolinfo)
{
  float pos[3];
  pos[0] = toolinfo -> tip[0];  // get the current position
  pos[1] = toolinfo -> tip[1];
  pos[2] = toolinfo -> tip[2];

  if (grabbed) {
    // tell system to move by the same amount the tip moved
    commandQueue -> append( new CmdTranslate( pos[0] - x, 
					      pos[1] - y,
					      pos[2] - z, 
					      CmdTranslate::BY));

  }
  x = pos[0];
  y = pos[1];
  z = pos[2];
}


// check which button was pushed, and change the appropriate state 
void TransTool::button_event(ToolControl *, ToolInfo *info)
{
  Buttons *checkbuttons;
  if (!(checkbuttons=info -> buttons))
    return;
  
  // if button 0 was pressed, change attachement states
  if (checkbuttons -> change(0) == 1) {
    grabbed = !grabbed;
  }
  // if button 1 was pressed, pick something
  if (checkbuttons -> change(1) == 1) {

    //// Get the atom and molecule numbers
    // From the pick list, get the pickable
    float pos[3];
    pos[0] = x; pos[1] = y; pos[2] = z;
    int tag;
    Pickable *p;
    if (display) {
      p = scene -> pick_check(display, 3, pos, tag);
      if (p) {
	Molecule *m = moleculeList -> check_pickable(p);
	if (m) {
	  // Then I have the molecule and atom
	  msgInfo << "Molecule: " << m -> id() << "  atom: " << tag << sendmsg;
	}
      }
    }
  }
    
  if (grabbed) {
     // initialize the translation info
     x = info -> tip[0];  // get the current position
     y = info -> tip[1];
     z = info -> tip[2];
  }
}
