/***************************************************************************
 *cr
 *cr		(C) Copyright 1995 The Board of Trustees of the
 *cr			    University of Illinois
 *cr			     All Rights Reserved
 *cr
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: TokenDisplayDevice.h,v $
 *	$Author: dalke $		$Locker:  $		   $State: Exp $
 *	$Revision: 1.2 $	      $Date: 96/03/24 07:07:20 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * FileRenderer type for listing all tokens in the display list
 *
 ***************************************************************************/
#ifndef TOKENDISPLAYDEVICE
#define TOKENDISPLAYDEVICE

#include <stdio.h>
#include "FileRenderer.h"

class TokenDisplayDevice : public FileRenderer {

private:

  // output file pointer
  FILE *ofp;

  // output file name
  char *ofpname;

  // was the file created?
  int Initialized;

protected:

  // functions to print up graphics
  void prpoint(const char *, float *);
  void prsphere(const char *, float *, float);
  void prline(const char *, float *, float *);
  void prcylinder(const char *, float *, float *, int, float);
  void prcylinder(const char *, int, float *);
  void prcone(const char *, float *, float *, int, float);
  void prtriangle(const char *, float *, float *, float *, float *, float *, float *);
  void prsquare(const char *, float *, float *, float *, float *, float *);
  void prmatop(const char *, float *);

public:
  // constructor/destructor

  TokenDisplayDevice(char *);
  virtual ~TokenDisplayDevice(void);

  virtual int prepare3D(int = TRUE);
  virtual void update(int = TRUE);
  virtual void render(void *);

};

#endif

