/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile$
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 95/06/01 23:08:16 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   Code to implement a null tracker to be driven by text commands
 *
 ***************************************************************************/


#include "TextTracker.h"

TextTracker::TextTracker(int num_sensors) : Tracker(num_sensors)
{
   status = TRACKER_OK;
   for (int i=0; i<sensors; i++) {
      sensorAvailable[i] = TRUE;
   }
   // and set things up so the trackers are initially line up along
   // the stage (if there is one) pointed away
   for (i=0; i<sensors; i++) {
      position[3*i+0] = (i - sensors/2.0)/4.0;  // x
      position[3*i+1] = -.75;             // y
      position[3*i+2] = 0;                // z
   }
   orientation[0] =    orientation[1] =    orientation[3] = 
   orientation[5] =    orientation[7] =    orientation[8] = 0;
   orientation[4] =    orientation[6] =    1;
   orientation[2] = -1;
   for (i=1; i<sensors; i++) {
      memcpy(orientation+9*i, orientation, 9*sizeof(float));
   }
}


