/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Surf.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1995/09/08 19:53:07 $
 *
 ***************************************************************************
 * DESCRIPTION:
 * C++ interface to the SURF executable written by Amitabh Varshney at
 * UNC.  The program is available at ftp.cs.unc.edu in 
 * /pub/projects/GRIP/SURF.
 *
 ***************************************************************************/

#ifndef SURF_H
#define SURF_H

#include "ResizeArray.h"

class Surf {
 public:
   typedef struct {
      float pos[3];
      float norm[3];
   } pos_norm;
   typedef struct tri {
      int index;
      pos_norm point[3];
      int operator ==(const tri&) { return 1;};
   } tri;
   float probe_radius;
   int is_okay;
   ResizeArray<tri> triangles;
 public:
   // constructor takes the probe radius and the array of x,y,z,r values
   Surf(float probe_r, int num_points, float *r, float *x, float *y, float *z);
   // destructor
//   ~Surf(void);
};
#endif

