/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: RenderFormsObj.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 95/05/13 01:45:31 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The on-screen menu to load a new molecule from a set of files.
 *
 ***************************************************************************/
#ifndef RENDERFORMSOBJ_H
#define RENDERFORMSOBJ_H

#include "FormsObj.h"


class RenderFormsObj : public FormsObj {

private:
  // select a filename. args are fname input object, and prompt
  void choose_filename(FL_OBJECT *, char *);

  // reset the render method browser
  void reset_render_list(void);

protected:
  // check if the given forms pointer is one for this menu, and generate
  // a command if necessary.  Return 'TRUE' if the pointer is for an object
  // in this menu.
  virtual int check(FL_OBJECT *);

  // do form-specific acting on commands ... no need here
  virtual int forms_act_on_command(int, Command *, int);

public:
  // class constructor and destructor
  RenderFormsObj(UIList *, CommandQueue *, int, int, int * = NULL);

  //
  // virtual routines for UI init/display
  //
  
  // initialize the user interface
  virtual void init(void);
  
  // reset the user interface (forces update of all info displays)
  virtual void reset(void);

};

#endif

