/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: RemoteList.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/05/11 23:42:36 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * A list of the currently and previously remotely connected simulations.
 * These are also Molecules, which are also stored in the MoleculeList
 * object.  However, this is not a Displayable object.
 *
 ***************************************************************************/

#include "RemoteList.h"
#include "MoleculeRemote.h"

///////////////////////  constructor  
RemoteList::RemoteList(void) : remList(8) {
  topRemote = (-1);
}


// return the index of the remote molecule with given ID (-1 if error)
int RemoteList::rem_index_from_id(int id) {
  for(int i=0; i < num(); i++) {
    if(id == (remList[i])->id())
      return i;
  }
  return (-1);
}


// add a new remote mol; return it's position in remList, or (-1) if error
int RemoteList::add_molecule(MoleculeRemote *m) {
  int newindex = remList.append(m);

  if(topRemote < 0)
    topRemote = newindex;
    
  return newindex;
}


// remove the Nth rem molecule from the list, i.e. delete it.  Return success.
// This does not do anything to the simulation status; that must be handled
// elsewhere.
int RemoteList::del_molecule(int n) {
  if(n >= 0 && n < num()) {
    remList.remove(n);
    if(topRemote >= n)
      // must change top remote.
      topRemote--;
      
    return TRUE;
  }      

  return FALSE;
}


// set the top molecule to the Nth one.  Return success.
int RemoteList::make_top(int n) {
  if(n >= 0 && n < num()) {
    topRemote = n;
    return TRUE;
  }
  
  return FALSE;
}

