/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: MoleculeFilePSF.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 95/05/11 23:18:17 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   Read the molecule information from a PSF file
 *
 ***************************************************************************/
#ifndef MOLECULEFILEPSF_H
#define MOLECULEFILEPSF_H

#include "MoleculeFile.h"

// Note that the reference to:
//  the textual description: in MoleculeFile
//  the constructor: in CmdMol.C
//
class MoleculeFilePSF : public MoleculeFile
{
 private:
  // read in the molecular data from the specified PSF file
  int createFromPSF(char *psffile);

 public:
   MoleculeFilePSF(char *, Scene *);
   MoleculeFilePSF(char *, Displayable *);
   virtual ~MoleculeFilePSF(void);

   // creates the molecule and returns success - also calls
   // the parent class create routines
   virtual int create(void);
};

#endif

