/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: MoleculeFileEDM.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 95/05/11 23:18:11 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   Read 3D scalar information from an electron density map file
 *  This can be used to draw isosurfaces
 *
 ***************************************************************************/
#ifndef MOLECULEFILEEDM_H
#define MOLECULEFILEEDM_H

#include "MoleculeFile.h"
#include "ReadEDM.h"
#include "ResizeArray.h"


class MoleculeFileEDM : public MoleculeFile
{
 private:
  // read in the molecular data from the specified PSF file
  edm_t *edm;


  void find_isosurface(float );  // redo the drawing list
     // to make the specified isosurface

 public:
  MoleculeFileEDM(char *, Scene *);
  MoleculeFileEDM(char *, Displayable *);
  virtual ~MoleculeFileEDM(void);
  
  // creates the molecule and returns success - also calls
  // the parent class create routines
  virtual int create(void);

  // this will be changed to make things more useful
  virtual void create_cmdlist(void);

  // I'm thinking of things like displaying multiple isosurfaces
  // and such, but that call for a pretty large change in the code
  virtual int add_rep(AtomColor *, AtomRep *, AtomSel *);
  virtual int change_rep(int n, AtomColor *, AtomRep *, AtomSel *);

  // return position of the center-of-volume
  virtual void cov(float &x, float &y, float &z);

  // scaling factor required to make the grid fit within (-1 ... 1)
  virtual float scale_factor(void);

};

#endif

