/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: MolFormsObj.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.9 $	$Date: 95/05/27 06:35:37 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The on-screen menu to list current molecules, and to add/delete them.
 *
 ***************************************************************************/

#include <stdio.h>
#include "MolFormsObj.h"
#include "MoleculeList.h"
#include "CmdDisplay.h"
#include "CmdMol.h"
#include "CmdMenu.h"
#include "Global.h"

// commands we are interested in
static int numCmds = 7;
static int cmdList[7] = {
	Command::MOL_ACTIVE,		Command::MOL_FIX,
	Command::MOL_ON,		Command::REMOTE_RUN,
	Command::REMOTE_ATTACH,		Command::ANIM_READ,
	Command::ANIM_DELETE };

/////////////////////////  constructor  
MolFormsObj::MolFormsObj(UIList *uil, CommandQueue *cq,
	int sh,int bd,int *npos) : FormsObj("mol", uil, cq, bd, npos) {
	
  // set values of common menu elements
  form = molMenu;
  lightButton = mol_menu_button;
  offButton = mol_menu_off;
  
  // register which commands we are interested in
  for(int i=0; i < numCmds; command_wanted(cmdList[i++]));
  
  // turn on if required
  if(sh)
    On();
}

/////////////////////////  private routines  

// set the state of the molecule browser
void MolFormsObj::reset_mol_browser(void) {
  char molstr[256];
  Molecule *mol;

  if(!moleculeList) {
    fl_clear_browser(mol_browser);
    return;
  }

  freeze();
  
  fl_clear_browser(mol_browser);
  for(int i=0; i < moleculeList->num(); i++) {
    mol = moleculeList->molecule(i);
    sprintf(molstr, "%c%c%c%c  %33s%7d  %7d       %s",
    	(moleculeList->is_top(i) ? 'T' : ' '),
	(moleculeList->active(i) ? 'A' : ' '),
	(moleculeList->displayed(i) ? 'D' : ' '),
	(moleculeList->fixed(i) ? 'F' : ' '),
	mol->name, mol->nAtoms, mol->num(), mol->source);
    fl_add_browser_line(mol_browser, molstr);
  }
    
  unfreeze();
}

//////////////////////  protected virtual routines  

// routine to check the main form for use
int MolFormsObj::check(FL_OBJECT *obj) {
  char molbuf[16];

  if(obj == mol_browser) {
    // do nothing

  } else if(obj == active_all) {
    addcommand(new CmdMolActive("all", TRUE, id()));

  } else if(obj == active_none) {
    addcommand(new CmdMolActive("all", FALSE, id()));
  
  } else if(obj == active_toggle) {
    for(int i=0; i < fl_get_browser_maxline(mol_browser); i++) {
      if(fl_isselected_browser_line(mol_browser, i+1)) {
        // toggle the active status of this molecule
        sprintf(molbuf,"%d",(moleculeList->molecule(i))->id());
	addcommand(new CmdMolActive(molbuf, ! moleculeList->active(i), id()));
      }
    }
    
  } else if(obj == display_all) {
    addcommand(new CmdMolOn("all", TRUE, id()));
    
  } else if(obj == display_none) {
    addcommand(new CmdMolOn("all", FALSE, id()));
    
  } else if(obj == display_toggle) {
    for(int i=0; i < fl_get_browser_maxline(mol_browser); i++) {
      if(fl_isselected_browser_line(mol_browser, i+1)) {
        // toggle the displayed status of this molecule
        sprintf(molbuf,"%d",(moleculeList->molecule(i))->id());
	addcommand(new CmdMolOn(molbuf, ! moleculeList->displayed(i), id()));
      }
    }
    
  } else if(obj == fixed_all) {
    addcommand(new CmdMolFix("all", TRUE, id()));
    
  } else if(obj == fixed_none) {
    addcommand(new CmdMolFix("all", FALSE, id()));
    
  } else if(obj == fixed_toggle) {
    for(int i=0; i < fl_get_browser_maxline(mol_browser); i++) {
      if(fl_isselected_browser_line(mol_browser, i+1)) {
        // toggle the fixed status of this molecule
        sprintf(molbuf,"%d",(moleculeList->molecule(i))->id());
	addcommand(new CmdMolFix(molbuf, ! moleculeList->fixed(i), id()));
      }
    }

  } else if(obj == make_top_button) {
    // make the first selected molecule the top one
    for(int i=0; i < fl_get_browser_maxline(mol_browser); i++) {
      if(fl_isselected_browser_line(mol_browser, i+1)) {      
        sprintf(molbuf,"%d",(moleculeList->molecule(i))->id());
        addcommand(new CmdMolTop(molbuf, id()));
        break;
      }
    }

  } else if(obj == single_mol_button) {
    // make the first selected molecule the ONLY active, displayed, top one
    // find the first selected molecule first
    *molbuf = '\0';
    for(int i=0; i < fl_get_browser_maxline(mol_browser); i++) {
      if(fl_isselected_browser_line(mol_browser, i+1)) {
        sprintf(molbuf,"%d",(moleculeList->molecule(i))->id());
        break;
      }
    }

    // then turn all others off
    if(*molbuf) {
      addcommand(new CmdMolActive("all", FALSE, id()));
      addcommand(new CmdMolOn("all", FALSE, id()));
      addcommand(new CmdMolActive(molbuf, TRUE, id()));
      addcommand(new CmdMolOn(molbuf, TRUE, id()));
      addcommand(new CmdMolTop(molbuf, id()));
      addcommand(new CmdResetView(id()));
    }

  } else if(obj == mol_delete) {
    for(int i=0; i < fl_get_browser_maxline(mol_browser); i++) {
      if(fl_isselected_browser_line(mol_browser, i+1)) {
        // toggle the fixed status of this molecule
        sprintf(molbuf,"%d",(moleculeList->molecule(i))->id());
	addcommand(new CmdMolDelete(molbuf, id()));
      }
    }
    
  } else
    return FALSE;

  return TRUE;
}


// do form-specific acting on commands.  Return whether
// any action was taken on this command.
// Arguments are the command type, command object, and the 
// success of the command (T or F).
// here, don't need this, just take parent class version
int MolFormsObj::forms_act_on_command(int type, Command *, int) {

  MSGDEBUG(3,"MolFormsObj: acting on command " << type << sendmsg);

  // check all the possible commands that we look for ...
  // base class already takes care of new, del, and top
  if(type == Command::MOL_ACTIVE || type == Command::MOL_ON ||
  		type == Command::MOL_FIX || type == Command::REMOTE_RUN ||
		type == Command::REMOTE_ATTACH ||
		type == Command::ANIM_READ || type == Command::ANIM_DELETE ) {
    reset_mol_browser();

  } else
    // unknown command type
    return FALSE;
    
  return TRUE;
}


//////////////////////  public virtual routines  

// initialize the user interface
void MolFormsObj::init(void) {
  freeze();
    // set all the basic values for controllers, etc
    fl_set_browser_fontstyle(mol_browser,FL_FIXED_STYLE);
    fl_clear_browser(mol_browser);
   
    // do a reset to set initial values
    reset();

  unfreeze();
}


// reset the user interface
void MolFormsObj::reset(void) {
  freeze();
    reset_mol_browser();
  unfreeze();
}

