/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Measure.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1996/05/14 04:51:19 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  This contains the prototypes for the various Tcl "measure" commands,
 * There are both Tcl commands and commands which just take selections.
 *
 ***************************************************************************/

#ifndef MEASURE_H
#define MEASURE_H
#include "tcl.h"
void init_measure_commands(Tcl_Interp *);

// standard errors available to everyone
// returns the string corresponding to an error (errno < 0)
const char *measure_error(int errno);



// compute the center of mass
// Takes an atom selection and one of three possible weights
//  1) if weight == NULL, uses weights of 1
//  2) if num == sel.selected ; assumes there is one weight per 
//           selected atom
//  3) if num == sel.num_atoms; assumes weight[i] is for atom[i]
// returns center coordinate in float com[3]
// returns 0 if valid data
//  -1 if no selection
//  -2 if no atoms in selection
//  -3 if number of weights is bad
//  -4 if com == NULL
//  -5 if total weight == 0
//  -6 if molecule no longer exists
int measure_center(AtomSel *sel, int num, float *weights, float *com);

// return the min/max range of coordinates in the selection
// puts results in min/max _coords
int measure_minmax(AtomSel *sel, float *min_coords, float *max_coords);

// compute the radius of gyration (with a weight factor)
// return the value in rgyr
int measure_rgyr(AtomSel *sel, int num, float *weight, float *rgyr);

// compute the rmsd between two selections (with a weight factor)
// return the value in rmsd
int measure_rmsd(AtomSel *sel1, AtomSel *sel2, int num, 
		 float *weight, float *rmsd);

// compute the best (rmsd) fit using the Kabsch method
// returns the transformation matrix in 'mat'
int measure_fit(AtomSel *sel1, AtomSel *sel2, int num1,
		  float *weight, int num2, float *weight2, Matrix4 *mat);

#endif

