/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: LightList.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 95/05/11 23:02:02 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * A list of Light objects; used to select a single active one and allow
 * the user to manipulate it.  Also provides an initial set of default lights.
 *
 ***************************************************************************/
#ifndef LIGHTLIST_H
#define LIGHTLIST_H

#include "Light.h"
#include "DisplayDevice.h"
class Scene;
class Matrix4;

// defines for this class
#define MAX_DISP_LIGHTS		DISP_LIGHTS


class LightList {

private:
  // simple array which stores the lights in this list.  There is a
  // maximum of MAX_DISP_LIGHTS lights
  Light *ltList[MAX_DISP_LIGHTS];

  // number of lights currently in the list, and the 'current' light
  int numLights, currLight;

public:
  LightList(Scene *);
  virtual ~LightList(void);
  
  //
  // operations to rotate the current light
  //

  void add_rot(float x, char axis);
  void add_rot(Matrix4 &);
  void set_rot(Matrix4 &);

  //
  // routines to have this class mimic a DLinkList (but it is simply
  // an array, to make it easier and smaller)
  //
  
  // return the Nth light, but don't change the current one
  Light *item(int n) {
    Light *retval = NULL;
    if(n >= 0 && n < numLights)
      retval = ltList[n];
    return retval;
  }

  // return the current light
  Light *current(void) {
    Light *retval = NULL;
    if(currLight >= 0)
      retval = ltList[currLight];
    return retval;
  }

  // return whether there is a current light
  int is_current(void) { return (current() != NULL); }

  // set the current light to the Nth value
  LightList& set(int n) {
    if(n >= 0 && n < numLights)
      currLight = n;
    return *this;
  }
  
  // reset the current light to the first one in the list
  LightList& reset(void) {
    if(numLights > 0)
      currLight = 0;
    else
      currLight = (-1);
    return *this;
  }
  
  // move the current light to the next in the list.  If the end of the
  // list is passed, the current light is undefined (-1).
  LightList& next(void) {
    if(currLight >= 0) {
      currLight++;
      if(currLight >= numLights)
        currLight = (-1);
    }
    return *this;
  }

};

#endif

