/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: GeometryTug.C,v $
 *	$Author: leech $	$Locker:  $	$State: Exp $
 *	$Revision: 1.3 $	$Date: 95/07/26 03:16:32 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Draws a tug between an atom and a specified position
 * into the display list for a given Displayable.
 *
 ***************************************************************************/
#include "GeometryTug.h"
#include "MoleculeList.h"
#include "Molecule.h"
#include "utilities.h"

////////////////////////  constructor  /////////////////////////
// constructor: molecule id, atom id, position, molecule list
GeometryTug::GeometryTug(int molid, int atomid, float *pos, MoleculeList *mlist)
	: GeometryMol(1, &molid, &atomid, mlist) {
    for (int i = 0; i < 3; i++)
	tugPos[i] = pos[i];
}

void GeometryTug::setTugPos(const float *pos) {
    for (int i = 0; i < 3; i++)
	tugPos[i] = pos[i];
}

void GeometryTug::getTugPos(float *pos) {
    for (int i = 0; i < 3; i++)
	pos[i] = tugPos[i];
}

////////////////////  public virtual routines  //////////////////////

// recalculate the value of this geometry, and return it
float GeometryTug::calculate(void) {
  return 1.0;

  // get coords to calculate distance
  // float pos1[3], pos2[3];
  // if(!normal_atom_coord(objIndex[0], comIndex[0], pos1))
  //   return 0.0;
  // if(!normal_atom_coord(objIndex[1], comIndex[1], pos2))
  //   return 0.0;
  //
  // subtract(pos2, pos2, pos1);
  // return(geomValue = norm(pos2));
}

// draw the geometry marker in the given Displayable's drawing list
void GeometryTug::draw_marker(Displayable *d) {

  // Get the transformed positions, and draw a line between them
  float pos[3];
  Molecule *mol = transformed_atom_coord(objIndex[0], comIndex[0], pos);
  if (!mol)
    return;

  // Transform tug position into world space
  int i;
  float xTugPos[3];
  for (i = 0; i < 3; i++)
    xTugPos[i] = tugPos[i];
  (mol->tm).multpoint3d(xTugPos,xTugPos);

  // draw a line into the given Displayable
  display_line(pos, xTugPos, d);

  // print value at tug position, then at atom position
  for (i = 0; i < 3; i++)
    valuePos[i] = pos[i];
  display_string("<atom>", d);

  for (i = 0; i < 3; i++)
    valuePos[i] = xTugPos[i];
  display_string("<tug>", d);
}

