/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: GeometryBond.h,v $
 *      $Author: dalke $        $Locker:  $                $State: Exp $
 *      $Revision: 1.4 $      $Date: 95/10/04 07:32:48 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Measures the angle between two atoms, and draws a marker for the bond
 * into the display list for a given Displayable.
 *
 ***************************************************************************/
#ifndef GEOMETRYBOND_H
#define GEOMETRYBOND_H

#include "GeometryMol.h"


class GeometryBond : public GeometryMol {

public:
  // constructor: molecule id's, atom indices, molecule list
  GeometryBond(int *, int *, MoleculeList *);
  
  //
  // public virtual routines
  //
  
  // recalculate the value of this geometry, and return it
  virtual float calculate(void);
  
  // draw the geometry marker in the given Displayable's drawing list
  virtual void draw_marker(Displayable *);

  // use the TCL variables
  virtual int sets_pick(void);
  virtual void set_pick(void);
};

#endif

