/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: DrawPatch.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 95/05/11 22:38:13 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Another Child Displayable component for a remote molecule; this displays
 * the configuration of any patches which have been stored for the current
 * timestep.  If no patch data is available, draws nothing.
 *
 ***************************************************************************/
#ifndef DRAWPATCH_H
#define DRAWPATCH_H

#include "Displayable.h"
#include "DispCmds.h"
class DrawMolecule;


class DrawPatch : public Displayable3D {

public:
  // enum for ways to display patches
  enum PatchDisplay { BYNONE, BYATOM, BYLOAD, BYNODE, TOTAL_PATCH_DISPLAY };

private:
  // parent molecule
  DrawMolecule *mol;
  
  // display method (one of PatchDisplay items)
  int displayMethod;

  // useful drawing command objects, used to create display list
  DispCmdColorIndex cmdColorIndex;
  DispCmdLine cmdLine;
  DispCmdMaterials cmdMaterials;
  DispCmdLineType cmdLineType;
  DispCmdLineWidth cmdLineWidth;
  
  // regenerate the command list
  void create_cmdlist(void);

  // do we need to completely redraw the list?
  int needRegenerate;

public:
  // constructor: parent molecule, and atom drawing methods
  DrawPatch(DrawMolecule *);
  
  // get/change the method for displaying patches
  int display_method(void) { return displayMethod; }
  int display_method(int);

  //
  // public virtual routines
  //
  
  // prepare for drawing ... do any updates needed right before draw.
  virtual void prepare(DisplayDevice *);

};

// string descriptions for patch display methods
extern char *patchDisplayMethodName[DrawPatch::TOTAL_PATCH_DISPLAY];

#endif

