/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: CoorPDB.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.6 $	$Date: 96/05/06 15:48:46 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * PDB file class - subclasses of ICoorFile and OCoorfile; used to read and
 * write PDB files.  When reading PDB files, the user may specify to read
 * structure info; if so, all the PDB info is read and stored.  If not,
 * only the coordinates are read.  When reading/writing PDB files, a
 * BaseMolecule must be specified, so that the structure can be properly
 * compared.
 *
 ***************************************************************************/
#ifndef PDBCOORFILE_H
#define PDBCOORFILE_H

#include "CoorFile.h"
class BaseMolecule;

// error flag values; should be > 0
#define COOR_ERR_NOTOPEN	1
#define COOR_ERR_EARLYEOF	2
#define COOR_ERR_NOATOMS	3
#define COOR_ERR_EXTRA		4
#define COOR_ERR_A_NOT_EQ	5

// PDB input object ... this only reads the coordinates.  As some point,
// the structure data should be used to determine which atom goes with which
// set of coords, but for right now this assumes that the PDB atoms are in
// the same order as the original structure file.

class ICoorPDB : public ICoorFile {

private:
  // molecule from which to take structure info
  BaseMolecule *mol;  

public:
  // constructor/destructor: BaseMolecule
  // (if # atoms == 0, scan file once for this info).
  ICoorPDB(BaseMolecule *);
  virtual ~ICoorPDB(void);

  // initialization routine.  Must be called before reading/writing any frames.
  // return TRUE if the file was properly initialized.
  virtual int init(char *);

  // read the next set of coordinates; return list of positions, or NULL if
  // error
  virtual Timestep *read(void);

};


// PDB output object

class OCoorPDB : public OCoorFile {

private:
  // molecule from which to take structure info
  BaseMolecule *mol;  

protected:

  //
  // protected virtual routines
  //
  
  // read file header ... here, nothing to do
  virtual void write_header(void);

public:
  // constructor/destructor: BaseMolecule pointer
  // (if # atoms == 0, scan file once for this info).
  OCoorPDB(BaseMolecule *);
  virtual ~OCoorPDB(void);

  // initialization routine.  Must be called before reading/writing any frames.
  // return TRUE if the file was properly initialized.
  virtual int init(char *);

  // write the next set of coordinates; given list of positions, returns total
  // frames written so far
  virtual int write(Timestep *);

};

// support function for write in OCoorPDB
// this allows other routines to write PDB files
//  The "alt_index" allows you to override the default value 
void write_pdb_record(BaseMolecule *mol, Timestep *pos, int i, FILE *cf,
		      int alt_index = -1);

void write_raw_pdb_record(FILE *outfile, char *recordname, int index, 
    char *atomname, char *resname, int resid, float x, float y, 
    float z, float occ, float beta, char *chain, char *segname);

#endif

