/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: ColorUser.C,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 95/05/11 22:10:59 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Simple base class for objects which will be needing to use a ColorList
 * for colors.  This class provides routines for being given a ColorList
 * object, and for being informed of when colors are changed.  The user
 * can create new "categories" of colors in the ColorList, and add specific
 * "color objects" to the category with an identifying name.  The user can
 * edit these colors via commands.
 *
 ***************************************************************************/

#include "ColorUser.h"
#include "utilities.h"


////////////////////////////  constructor/destructor
ColorUser::ColorUser(void) {
  colorList = NULL;
}
 
ColorUser::~ColorUser(void) { }


////////////////////////////  protected routines

// virtual function which is called when a new colorlist is provided.
// may not need to do anything, which is the default cause
void ColorUser::do_use_colors(void) { }

// do action due to the fact that a color for the given ColorList for
// the specified category has changed
void ColorUser::do_color_changed(ColorList *, int) { }


////////////////////////////  public routines
// set up to use a specific ColorList.  This stores the list, and calls
// a function to do specific action when given a new list
void ColorUser::use_colors(ColorList *collist) {
  colorList = collist;
  do_use_colors();
}

// do action due to the fact that a color for the given ColorList for
// the specified category has changed.  By default, just does the
// particular special action.
void ColorUser::color_changed(ColorList *collist, int c) {
  do_color_changed(collist, c);
}

