/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: CmdUtil.h,v $
 *      $Author: billh $        $Locker:  $                $State: Exp $
 *      $Revision: 1.5 $      $Date: 95/05/11 22:06:33 $
 *
 ***************************************************************************
 * DESCRIPTION:
 * 
 * Command objects for doing various utilities, such as executing a shell,
 * displaying help, or quitting
 *
 ***************************************************************************/
#ifndef CMDUTIL_H
#define CMDUTIL_H

#include "Command.h"

// The following uses the Cmdtypes HELP, RESET, DEBUG,
// QUIT, WAIT, ECHO, LOGWRITE, LOGREAD from the Command class

// text callback routine for quit, help, wait, echo, debug, log, play
extern int text_cmd_quit(int, char **, CommandQueue *, int);
extern int text_cmd_help(int, char **, CommandQueue *, int);
extern int text_cmd_wait(int, char **, CommandQueue *, int);
extern int text_cmd_echo(int, char **, CommandQueue *, int);
extern int text_cmd_debug(int, char **, CommandQueue *, int);
extern int text_cmd_log(int, char **, CommandQueue *, int);
extern int text_cmd_play(int, char **, CommandQueue *, int);


//////////// display help, in various formats
class CmdHelp : public Command {
private:
  // word to get help on (if NULL, general help)
  char *word;

protected:
  // do the actual action
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  CmdHelp(char *, int=(-1));
  virtual ~CmdHelp(void);
};


//////////// reset all the UI's
class CmdReset : public Command {
private:
  // which UI to reset.  if < 0, reset all
  int resetUI;
    
protected:
  // do the actual action
  virtual int do_execute(void);

public:
  // constructor: which UI to reset, UI id of creator
  CmdReset(int=(-1), int=(-1));
};


//////////// exit the program, possibly asking for confirmation
class CmdQuit : public Command {
private:
  // ask for confirmation?
  int askConfirm;

protected:
  // do the actual action
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  // constructor: confirm quitting, id of creator
  CmdQuit(int, int=(-1));
};


//////////// set the debug level for the program
class CmdDebug : public Command {
public:
  // are we changing the debug level, or turning on/off?
  enum DebugAction { TOGGLE, LEVEL };
  DebugAction action;

  // new debug level, or whether to turn on/off
  int newVal;
    
protected:
  // do the actual action
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  CmdDebug(DebugAction, int, int=(-1));
};


//////////// tell the text processor to wait an interval between commands
class CmdWait : public Command {
private:
  // number of seconds to wait
  float delay;

protected:
  // do the actual action
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  CmdWait(float, int=(-1));
};


//////////// toggle on/off whether to echo items to the console
class CmdEcho : public Command {
private:
  // turn echoing on/off (if 1, turn on; if 0, turn off; if < 0, unknown)
  int onoff;

protected:
  // do the actual action
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  CmdEcho(char *, int=(-1));
};


//////////// turn on/off logging of commands to a file
class CmdLogWrite : public Command {
private:
  // file to log commands to (if NULL, turn OFF logging)
  char *logfile;

protected:
  // do the actual action
  virtual int do_execute(void);

public:
  CmdLogWrite(char *, int=(-1));
  virtual ~CmdLogWrite(void);
};


//////////// start playing back a log file/script
class CmdLogRead : public Command {
private:
  // file to read
  char *logfile;

protected:
  // do the actual action
  virtual int do_execute(void);

public:
  CmdLogRead(char *, int=(-1));
  virtual ~CmdLogRead(void);
};


#endif

